% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.control.R
\name{freq.control}
\alias{freq.control}
\title{Control settings for \code{freqlist} function}
\usage{
freq.control(sparse = FALSE, single = FALSE, dupLabels = FALSE,
  digits.count = 0L, digits.pct = 2L, ..., digits = NULL)
}
\arguments{
\item{sparse}{a logical value indicating whether to keep rows with counts of zero.
The default is \code{FALSE} (drop zero-count rows).}

\item{single}{logical, indicating whether to collapse results created using a strata variable into a single table for printing}

\item{dupLabels}{logical: should labels which are the same as the row above be printed? The default (\code{FALSE}) more
closely approximates \code{PROC FREQ} output from SAS, where a label carried down from the row above is left blank.}

\item{digits.count}{Number of decimal places for count values.}

\item{digits.pct}{Number of decimal places for percents.}

\item{...}{additional arguments.}

\item{digits}{A deprecated argument}
}
\value{
A list with settings to be used within the \code{freqlist} function.
}
\description{
Control test and summary settings for the \code{\link{freqlist}} function.
}
\seealso{
\code{\link{freqlist}}, \code{\link{summary.freqlist}}, \code{\link{freqlist.internal}}
}
\author{
Ethan Heinzen
}
