% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsum.R
\name{modelsum}
\alias{modelsum}
\title{Fit models over each of a set of independent variables with a response variable}
\usage{
modelsum(
  formula,
  family = "gaussian",
  data,
  adjust = NULL,
  na.action = NULL,
  subset = NULL,
  weights = NULL,
  strata,
  control = NULL,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}}; a symbolic description of the variables to be modeled.  See "Details" for more information.}

\item{family}{similar mechanism to \code{\link[stats]{glm}}, where the model to be fit is driven by the family.
Options include: binomial, gaussian, survival, poisson, negbin, and ordinal. These can be passed as a string, as a function,
or as a list resulting from a call to one of the functions. See \code{\link{modelsum.family}} for details on
survival and ordinal families.}

\item{data}{an optional data.frame, list or environment (or object coercible by \code{\link[base]{as.data.frame}} to a data frame) containing the
variables in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically
the environment from which \code{modelsum} is called.}

\item{adjust}{an object of class \code{\link{formula}}, listing variables to adjust by in all models. Specify as a one-sided formula,
like: \code{~Age+ Sex}.}

\item{na.action}{a function which indicates what should happen when the data contain \code{NA}s.
The default (\code{NULL}) is to use the defaults of \code{\link[stats]{lm}}, \code{\link[stats]{glm}}, or \code{\link[survival]{coxph}},
depending on the \code{family} specifications.}

\item{subset}{an optional vector specifying a subset of observations (rows of \code{data}) to be used in the results.
If \code{strata} is missing, this works as vector of logicals or an index; otherwise, it should be a logical vector.}

\item{weights}{an optional vector specifying the weights to apply to each data observation (rows of \code{data})}

\item{strata}{a vector of strata to separate model summaries by an additional group.}

\item{control}{control parameters to handle optional settings within \code{modelsum}.  Arguments for \code{modelsum.control}
can be passed to \code{modelsum} via the \code{...} argument, but if a control object and \code{...} arguments are both supplied,
the latter are used. See \code{\link{modelsum.control}} for other details.}

\item{...}{additional arguments to be passed to internal \code{modelsum} functions.}
}
\value{
An object with class \code{c("modelsum", "arsenal_table")}
}
\description{
Fit and summarize models for each independent (x) variable with a response variable (y), with options to adjust by variables for each model.
}
\examples{

data(mockstudy)

tab1 <- modelsum(bmi ~ sex + age, data = mockstudy)
summary(tab1, text = TRUE)

tab2 <- modelsum(alk.phos ~ arm + ps + hgb, adjust = ~ age + sex,
                 family = "gaussian", data = mockstudy)
summary(tab2, text = TRUE)

summary(tab2, show.intercept = FALSE, text = TRUE)

tab2.df <- as.data.frame(tab2)

tab2.df[1:5,]
}
\seealso{
\code{\link{arsenal_table}}, \code{\link{modelsum.control}}, \code{\link{summary.modelsum}},
  \code{\link{modelsum.internal}}, \code{\link{formulize}}
}
\author{
Jason Sinnwell, Patrick Votruba, Beth Atkinson, Gregory Dougherty, and Ethan Heinzen, adapted from SAS Macro of the same name
}
