% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicated.R
\name{duplicated}
\alias{duplicated}
\alias{duplicated,itemMatrix-method}
\alias{duplicated,rules-method}
\alias{duplicated,itemsets-method}
\title{Find Duplicated Elements}
\usage{
duplicated(x, incomparables = FALSE, ...)

\S4method{duplicated}{itemMatrix}(x, incomparables = FALSE)

\S4method{duplicated}{rules}(x, incomparables = FALSE)

\S4method{duplicated}{itemsets}(x, incomparables = FALSE)
}
\arguments{
\item{x}{an object of class \link{itemMatrix} or \link{associations}.}

\item{incomparables}{argument currently unused.}

\item{\dots}{further arguments (currently unused).}
}
\value{
A logical vector indicating duplicated elements.
}
\description{
Provides the generic function \code{duplicated()} and the methods to find
duplicated elements in
\link{itemMatrix}, \link{associations} and their subclasses.
}
\examples{
data("Adult")

r1 <- apriori(Adult[1:1000], parameter = list(support = 0.5))
r2 <- apriori(Adult[1001:2000], parameter = list(support = 0.5))

## Note this creates a collection of rules from two sets of rules
r_comb <- c(r1, r2)
duplicated(r_comb)
}
\seealso{
Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{manip}
