context("parse-value-labels-sps")



test_that("Number of value label columns are correct", {

  expect_equal(length(crosswalk_parsed_sps$value_labels), 19)
  expect_equal(length(parole_parsed_sps$value_labels), 51)
  #  expect_equal(length(ucr1985_parsed_sps$value_labels), )
  #  expect_equal(length(ucr1986_parsed_sps$value_labels), )
  #  expect_equal(length(ucr2000_parsed_sps$value_labels), )
  #  expect_equal(length(ucr2006_parsed_sps$value_labels), )
  #  expect_equal(length(sac_parsed_sps$value_labels), )
  expect_equal(length(sex_offender_parsed_sps$value_labels), 32)
  #  expect_equal(length(ucr1960_parsed_sps$value_labels), )
  expect_equal(length(weimar_parsed_sps$value_labels), 0)
  expect_equal(length(acs_parsed_sps$value_labels), 4)
  expect_equal(length(nibrs_parsed_sps$value_labels), 9)
  #  expect_equal(length(prisoners_parsed_sps$value_labels), )
  expect_equal(length(ca_vital_parsed_sps$value_labels), 36)
  expect_equal(length(property_stolen_parsed_sps$value_labels), 15)
  #  expect_equal(length(ASR), 36)
  expect_equal(length(corrections_parsed_sps$value_labels), 9)

  expect_equal(length(jail_2010_parsed_sps$value_labels), 123)
  expect_equal(length(sadc_parsed_sps$value_labels), 135)
  expect_equal(length(health_nutrition_parsed_sps$value_labels), 36)
#  expect_equal(length(india_human_parsed_sps$value_labels), )

  expect_equal(length(step_in_parsed_sps$value_labels), 4)
  expect_equal(length(census_police_parsed_sps$value_labels), 76)
  expect_true(is.null(cps_1973_parsed_sps$value_labels))


  # expect_equal(length(cps_2004_parsed_sps$value_labels), )
  # expect_equal(length(drug_abuse_parsed_sps$value_labels), )
   expect_true(is.null(british_crime_teen_parsed_sps$value_labels))
  # expect_equal(length(detroit_parsed_sps$value_labels), )
  # expect_equal(length(worry_parsed_sps$value_labels), )


   expect_equal(length(cambridge_parsed_sps$value_labels), 879)
   #expect_equal(length(guam_parsed_sps$value_labels), )
   expect_equal(length(china_2002_parsed_sps$value_labels), 79)
   expect_equal(length(china_1995_parsed_sps$value_labels), 29)
   expect_equal(length(china_1998_parsed_sps$value_labels), 47)
   expect_true(is.null(indonesia_parsed_sps$value_labels))
   expect_equal(length(UN_crime_parsed_sps$value_labels), 119)
   expect_true(is.null(county_arrest_parsed_sps$value_labels))

   expect_true(is.null(escolar_2006_parsed_sps$value_labels))
   expect_true(is.null(ca_sedd_2005_ahal_parsed_sps$value_labels))


   expect_equal(length(mtf_1999_parsed_sps$value_labels), 101)
   expect_equal(length(mtf_2003_parsed_sps$value_labels), 107)
   expect_equal(length(mtf_1990_parsed_sps$value_labels), 109)
   expect_equal(length(mtf_1989_parsed_sps$value_labels), 108)
   expect_equal(length(mtf_2004_parsed_sps$value_labels), 106)
   expect_equal(length(mtf_2002_parsed_sps$value_labels), 101)
   expect_equal(length(mtf_1993_parsed_sps$value_labels), 109)
   expect_equal(length(mtf_1991_parsed_sps$value_labels), 109)
   expect_equal(length(mtf_1992_parsed_sps$value_labels), 109)
  # expect_equal(length(mtf_1979_parsed_sps$value_labels), )
   expect_true(is.null(missing_value_no_s_parsed_sps$value_labels))
})

test_that("Monitoring the Future 1979 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_1979_parsed_sps$value_labels)),
               c("V1",
                 "V3",
                 "V13",
                 "V16",
                 "V17",
                 "V4101"))
  expect_equal(tail(names(mtf_1979_parsed_sps$value_labels)),
               c("V4371",
                 "V4372",
                 "V4373",
                 "V4374",
                 "V9001",
                 "V9002"))

  expect_equal(mtf_1979_parsed_sps$value_labels$V1,
               c("1979" = "79"))
  expect_equal(mtf_1979_parsed_sps$value_labels$V3,
               c("FORM 4" = "4"))
  expect_equal(mtf_1979_parsed_sps$value_labels$V4103,
               c("NO:(1)" = "1",
                 "YES:(2)" = "2"))
  expect_equal(mtf_1979_parsed_sps$value_labels$V4158,
               c("NO" = "0",
                 "YES" = "1"))
  expect_equal(mtf_1979_parsed_sps$value_labels$V4245,
               c("NOT IMPORTANT" = "1",
                 "A LITTLE IMPORTANT" = "2",
                 "PRETTY IMPORTANT" = "3",
                 "VERY IMPORTANT" = "4"))
  expect_equal(mtf_1979_parsed_sps$value_labels$V4248,
               c("LABORER (CAR WASHER, SANITARY WORKER, FARM LABORER)" = "1",
                 "SERVICE WORKER" = "2",
                 "OPERATIVE OR SEMI-SKILLED WORKER" = "3",
                 "SALES CLERK IN A RETAIL STORE" = "4",
                 "CLERICAL OR OFFICE WORKER" = "5",
                 "PROTECTIVE SERVICE (POLICE OFFICER, FIREMAN, DETECTIVE)" = "6",
                 "MILITARY SERVICE" = "7",
                 "CRAFTSMAN OR SKILLED WORKER" = "8",
                 "FARM OWNER, FARM MANAGER" = "9",
                 "OWNER OF SMALL BUSINESS (RESTAURANT OWNER, SHOP OWNER)" = "10",
                 "SALES REPRESENTATIVE" = "11",
                 "MANAGER OR ADMINISTRATOR" = "12",
                 "PROFESSIONAL WITHOUT DOCTORAL DEGREE" = "13",
                 "PROFESSIONAL WITH DOCTORAL DEGREE OR EQUIVALENT" = "14",
                 "FULL-TIME HOMEMAKER OR HOUSEWIFE" = "15",
                 "DON T KNOW-GO TO Q.A13" = "16"))
  expect_equal(mtf_1979_parsed_sps$value_labels$V9002,
               c("PART 4: FORM 4 QUESTIONNAIRE" = "4"))
})

test_that("Monitoring the Future 1992 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_1992_parsed_sps$value_labels)),
               c("V1",
                 "V3",
                 "V13",
                 "V16",
                 "V17",
                 "V148"))
  expect_equal(tail(names(mtf_1992_parsed_sps$value_labels)),
               c("V145",
                 "V146",
                 "V147",
                 "V208",
                 "V209",
                 "V210"))

  expect_equal(mtf_1992_parsed_sps$value_labels$V1,
               c("1992" = "92"))
  expect_equal(mtf_1992_parsed_sps$value_labels$V3,
               c("Form 1" = "1",
                 "Form 2" = "2",
                 "Form 3" = "3",
                 "Form 4" = "4",
                 "Form 5" = "5",
                 "Form 6" = "6"))
  expect_equal(mtf_1992_parsed_sps$value_labels$V148,
               c("Before 71" = "1",
                 "1971" = "2",
                 "1972" = "3",
                 "1973" = "4",
                 "1974" = "5",
                 "1975" = "6",
                 "1976" = "7",
                 "After 1976" = "8"))
  expect_equal(mtf_1992_parsed_sps$value_labels$V190,
               c("No" = "0",
                 "Yes" = "1"))
  expect_equal(mtf_1992_parsed_sps$value_labels$V193,
               c("None" = "1",
                 "$1-5" = "2",
                 "$6-10" = "3",
                 "$11-20" = "4",
                 "$21-35" = "5",
                 "$36-50" = "6",
                 "$51-75" = "7",
                 "$76-125" = "8",
                 "$126+" = "9"))
  expect_equal(mtf_1992_parsed_sps$value_labels$V209,
               c("December 1993 release" = "1"))
  expect_equal(mtf_1992_parsed_sps$value_labels$V210,
               c("Part 1: Core" = "1"))
})

test_that("Monitoring the Future 1991 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_1991_parsed_sps$value_labels)),
               c("V1",
                 "V3",
                 "V13",
                 "V16",
                 "V17",
                 "V148"))
  expect_equal(tail(names(mtf_1991_parsed_sps$value_labels)),
               c("V145",
                 "V146",
                 "V147",
                 "V208",
                 "V209",
                 "V210"))

  expect_equal(mtf_1991_parsed_sps$value_labels$V1,
               c("1991" = "91"))
  expect_equal(mtf_1991_parsed_sps$value_labels$V183,
               c("Definitely won t" = "1",
                 "Probably won t" = "2",
                 "Probably will" = "3",
                 "Definitely will" = "4"))
  expect_equal(mtf_1991_parsed_sps$value_labels$V180,
               c("Definitely won t" = "1",
                 "Probably won t" = "2",
                 "Probably will" = "3",
                 "Definitely will" = "4"))
  expect_equal(mtf_1991_parsed_sps$value_labels$V108,
               c("None" = "1",
                 "Once" = "2",
                 "Twice" = "3",
                 "Three to five times" = "4",
                 "Six to nine times" = "5",
                 "Ten or more times" = "6"))
  expect_equal(mtf_1991_parsed_sps$value_labels$V208,
               c("ICPSR Study Number" = "9871"))
  expect_equal(mtf_1991_parsed_sps$value_labels$V209,
               c("February 1993 release" = "1"))
  expect_equal(mtf_1991_parsed_sps$value_labels$V210,
               c("Part 1: Core" = "1"))
})

test_that("Monitoring the Future 1989 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_1989_parsed_sps$value_labels)),
               c("V1",
                 "V13",
                 "V16",
                 "V17",
                 "V49",
                 "V101"))
  expect_equal(tail(names(mtf_1989_parsed_sps$value_labels)),
               c("V205",
                 "V206",
                 "V207",
                 "V208",
                 "V209",
                 "V210"))

  expect_equal(mtf_1989_parsed_sps$value_labels$V1,
               c("1989" = "89"))
  expect_equal(mtf_1989_parsed_sps$value_labels$V16,
               c("Not self-representing" = "0",
                 "Self-representing" = "1"))
  expect_equal(mtf_1989_parsed_sps$value_labels$V103,
               c("NO" = "1",
                 "YES" = "2"))
  expect_equal(mtf_1989_parsed_sps$value_labels$V131,
               c("0 OCCASIONS" = "1",
                 "1-2" = "2",
                 "3-5" = "3",
                 "6-9" = "4",
                 "10-19" = "5",
                 "20-39" = "6",
                 "40 OR MORE" = "7"))
  expect_equal(mtf_1989_parsed_sps$value_labels$V133,
               c("0 OCCASIONS" = "1",
                 "1-2" = "2",
                 "3-5" = "3",
                 "6-9" = "4",
                 "10-19" = "5",
                 "20-39" = "6",
                 "40 OR MORE" = "7"))
  expect_equal(mtf_1989_parsed_sps$value_labels$V209,
               c("DECEMBER, 1992 RELEASE" = "1"))
  expect_equal(mtf_1989_parsed_sps$value_labels$V210,
               c("PART 1: CORE VARIABLES" = "1"))
})


test_that("Monitoring the Future 1990 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_1990_parsed_sps$value_labels)),
               c("V1",
                 "V3",
                 "V13",
                 "V16",
                 "V17",
                 "V148"))
  expect_equal(tail(names(mtf_1990_parsed_sps$value_labels)),
               c("V145",
                 "V146",
                 "V147",
                 "V208",
                 "V209",
                 "V210"))

  expect_equal(mtf_1990_parsed_sps$value_labels$V1,
               c("1990" = "90"))
  expect_equal(mtf_1990_parsed_sps$value_labels$V3,
               c("Form 1" = "1",
                 "Form 2" = "2",
                 "Form 3" = "3",
                 "Form 4" = "4",
                 "Form 5" = "5",
                 "Form 6" = "6"))
  expect_equal(mtf_1990_parsed_sps$value_labels$V188,
               c("No" = "0",
                 "Yes" = "1"))
  expect_equal(mtf_1990_parsed_sps$value_labels$V190,
               c("No" = "0",
                 "Yes" = "1"))
  expect_equal(mtf_1990_parsed_sps$value_labels$V208,
               c("ICPSR study number" = "9745"))
  expect_equal(mtf_1990_parsed_sps$value_labels$V209,
               c("January 1993 release" = "1"))
  expect_equal(mtf_1990_parsed_sps$value_labels$V210,
               c("Part 1: Core" = "1"))
})


test_that("Monitoring the Future 2003 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_2003_parsed_sps$value_labels)),
               c("CASEID",
                 "V13",
                 "V16",
                 "V17",
                 "V1",
                 "V3"))
  expect_equal(tail(names(mtf_2003_parsed_sps$value_labels)),
               c("V112",
                 "V113",
                 "V114",
                 "V205",
                 "V206",
                 "V207"))

  expect_equal(mtf_2003_parsed_sps$value_labels$CASEID,
               c("MISSING" = "-9"))
  expect_equal(mtf_2003_parsed_sps$value_labels$V13,
               c("MISSING" = "-9",
                 "NE" = "1",
                 "NC" = "2",
                 "S" = "3",
                 "W" = "4"))
  expect_equal(mtf_2003_parsed_sps$value_labels$V1,
               c("MISSING" = "-9"))
  expect_equal(mtf_2003_parsed_sps$value_labels$V200,
               c("MISSING" = "-9",
                 "None:(0)" = "0",
                 "One:(1)" = "1",
                 "Two:(2)" = "2",
                 "3-4 or +:(3-4)" = "3"))
  expect_equal(mtf_2003_parsed_sps$value_labels$V205,
               c("MISSING" = "-9",
                 "ARMY:(1)" = "1",
                 "NAVY:(2)" = "2",
                 "MARINES:(3)" = "3",
                 "AIRFORCE:(4)" = "4",
                 "COAST GD:(5)" = "5",
                 "UNCERTN:(6)" = "6"))
  expect_equal(mtf_2003_parsed_sps$value_labels$V206,
               c("MISSING" = "-9",
                 "NO:(1)" = "1",
                 "UNCERTN:(2)" = "2",
                 "YES:(3)" = "3"))
  expect_equal(mtf_2003_parsed_sps$value_labels$V207,
               c("MISSING" = "-9",
                 "NO:(1)" = "1",
                 "UNCERTN:(2)" = "2",
                 "YES:(3)" = "3"))
})


test_that("Monitoring the Future 1999 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_1999_parsed_sps$value_labels)),
               c("V13",
                 "V130",
                 "V131",
                 "V132",
                 "V49",
                 "V101"))
  expect_equal(tail(names(mtf_1999_parsed_sps$value_labels)),
               c("V112",
                 "V113",
                 "V114",
                 "V205",
                 "V206",
                 "V207"))

  expect_equal(mtf_1999_parsed_sps$value_labels$V13,
               c("MISSING" = "-9",
                 "NE" = "1",
                 "NC" = "2",
                 "S" = "3",
                 "W" = "4"))
  expect_equal(mtf_1999_parsed_sps$value_labels$V130,
               c("MISSING" = "-9",
                 "0 OCCAS" = "1",
                 "1-2X" = "2",
                 "3-5X" = "3",
                 "6-9X" = "4",
                 "10-19X" = "5",
                 "20-39X" = "6",
                 "40+OCCAS" = "7"))
  expect_equal(mtf_1999_parsed_sps$value_labels$V139,
               c("MISSING" = "-9",
                 "0 OCCAS" = "1",
                 "1-2X" = "2",
                 "3-5X" = "3",
                 "6-9X" = "4",
                 "10-19X" = "5",
                 "20-39X" = "6",
                 "40+OCCAS" = "7"))
  expect_equal(mtf_1999_parsed_sps$value_labels$V135,
               c("MISSING" = "-9",
                 "0 OCCAS" = "1",
                 "1-2X" = "2",
                 "3-5X" = "3",
                 "6-9X" = "4",
                 "10-19X" = "5",
                 "20-39X" = "6",
                 "40+OCCAS" = "7"))
  expect_equal(mtf_1999_parsed_sps$value_labels$V144,
               c("MISSING" = "-9",
                 "0 OCCAS" = "1",
                 "1-2X" = "2",
                 "3-5X" = "3",
                 "6-9X" = "4",
                 "10-19X" = "5",
                 "20-39X" = "6",
                 "40+OCCAS" = "7"))
  expect_equal(mtf_1999_parsed_sps$value_labels$V206,
               c("MISSING" = "-9",
                 "NO" = "1",
                 "UNCERTN" = "2",
                 "YES" = "3"))
  expect_equal(mtf_1999_parsed_sps$value_labels$V207,
               c("MISSING" = "-9",
                 "NO" = "1",
                 "UNCERTN" = "2",
                 "YES" = "3"))
})


test_that("Monitoring the Future 1993 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_1993_parsed_sps$value_labels)),
               c("V1",
                 "V3",
                 "V13",
                 "V16",
                 "V17",
                 "V148"))
  expect_equal(tail(names(mtf_1993_parsed_sps$value_labels)),
               c("V145",
                 "V146",
                 "V147",
                 "V208",
                 "V209",
                 "V210"))

  expect_equal(mtf_1993_parsed_sps$value_labels$V1,
               c("1992" = "92"))
  expect_equal(mtf_1993_parsed_sps$value_labels$V13,
               c("NORTHEAST" = "1",
                 "NORTH CENTRAL" = "2",
                 "SOUTH" = "3",
                 "WEST" = "4"))
  expect_equal(mtf_1993_parsed_sps$value_labels$V17,
               c("Non-SMSA" = "0",
                 "SMSA" = "1"))
  expect_equal(mtf_1993_parsed_sps$value_labels$V185,
               c("No" = "0",
                 "Yes" = "1"))
  expect_equal(mtf_1993_parsed_sps$value_labels$V186,
               c("No" = "0",
                 "Yes" = "1"))
  expect_equal(mtf_1993_parsed_sps$value_labels$V209,
               c("December 1993 release" = "1"))
  expect_equal(mtf_1993_parsed_sps$value_labels$V210,
               c("Part 1: Core" = "1"))
})


test_that("Monitoring the Future 2004 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_2004_parsed_sps$value_labels)),
               c("V1",
                 "V13",
                 "V16",
                 "V17",
                 "V101",
                 "V102"))
  expect_equal(tail(names(mtf_2004_parsed_sps$value_labels)),
               c("V204",
                 "V205",
                 "V206",
                 "V207",
                 "V9001",
                 "V9002"))

  expect_equal(mtf_2004_parsed_sps$value_labels$V1,
               c("1980" = "80"))
  expect_equal(mtf_2004_parsed_sps$value_labels$V13,
               c("NE" = "1",
                 "NC" = "2",
                 "S" = "3",
                 "W" = "4"))
  expect_equal(mtf_2004_parsed_sps$value_labels$V17,
               c("NON-SMSA" = "0",
                 "SMSA" = "1"))
  expect_equal(mtf_2004_parsed_sps$value_labels$V130,
               c("0 OCCASIONS" = "1",
                 "1-2" = "2",
                 "3-5" = "3",
                 "6-9" = "4",
                 "10-19" = "5",
                 "20-39" = "6",
                 "40 OR MORE" = "7"))
  expect_equal(mtf_2004_parsed_sps$value_labels$V206,
               c("NO" = "1",
                 "UNCERTAIN" = "2",
                 "YES" = "3"))
  expect_equal(mtf_2004_parsed_sps$value_labels$V9001,
               c("ICPSR STUDY NUMBER" = "7900"))
  expect_equal(mtf_2004_parsed_sps$value_labels$V9002,
               c("PART 6: CORE QUESTIONNAIRE" = "6"))
})


test_that("Monitoring the Future 2002 - parsed value labels are accurate", {

  expect_equal(head(names(mtf_2002_parsed_sps$value_labels)),
               c("V13",
                 "V130",
                 "V131",
                 "V132",
                 "V49",
                 "V101"))
  expect_equal(tail(names(mtf_2002_parsed_sps$value_labels)),
               c("V112",
                 "V113",
                 "V114",
                 "V205",
                 "V206",
                 "V207"))

  expect_equal(mtf_2002_parsed_sps$value_labels$V13,
               c("MISSING" = "-9",
                 "NE" = "1",
                 "NC" = "2",
                 "S" = "3",
                 "W" = "4"))
  expect_equal(mtf_2002_parsed_sps$value_labels$V132,
               c("MISSING" = "-9",
                 "0 OCCAS (1)" = "1",
                 "1-2X (2)" = "2",
                 "3-5X (3)" = "3",
                 "6-9X (4)" = "4",
                 "10-19X (5)" = "5",
                 "20-39X (6)" = "6",
                 "40+OCCAS (7)" = "7"))
  expect_equal(mtf_2002_parsed_sps$value_labels$V49,
               c("MISSING" = "-9",
                 "3 OR MORE" = "3"))
  expect_equal(mtf_2002_parsed_sps$value_labels$V155,
               c("MISSING" = "-9",
                 "NT MARKD:(0)" = "0",
                 "MARKED:(1)" = "1"))
  expect_equal(mtf_2002_parsed_sps$value_labels$V179,
               c("MISSING" = "-9",
                 "D:(1)" = "1",
                 "C-:(2)" = "2",
                 "C:(3)" = "3",
                 "C+:(4)" = "4",
                 "B-:(5)" = "5",
                 "B:(6)" = "6",
                 "B+:(7)" = "7",
                 "A-:(8)" = "8",
                 "A:(9)" = "9"))
  expect_equal(mtf_2002_parsed_sps$value_labels$V206,
               c("MISSING" = "-9",
                 "NO:(1)" = "1",
                 "UNCERTN:(2)" = "2",
                 "YES:(3)" = "3"))
  expect_equal(mtf_2002_parsed_sps$value_labels$V207,
               c("MISSING" = "-9",
                 "NO:(1)" = "1",
                 "UNCERTN:(2)" = "2",
                 "YES:(3)" = "3"))
})


test_that("Cambridge - parsed value labels are accurate", {

  expect_equal(head(names(cambridge_parsed_sps$value_labels)),
               c("V1",
                 "V2",
                 "V3",
                 "V5",
                 "V6",
                 "V7"))
  expect_equal(tail(names(cambridge_parsed_sps$value_labels)),
               c("V875",
                 "V876",
                 "V877",
                 "V878",
                 "V879",
                 "V880"))

  expect_equal(cambridge_parsed_sps$value_labels$V1,
               c("ICPSR STUDY NO." = "8488"))
  expect_equal(cambridge_parsed_sps$value_labels$V2,
               c("2ND VERSION" = "2"))
  expect_equal(cambridge_parsed_sps$value_labels$V13,
               c("NONE" = "0",
                 "ONE" = "1",
                 "TWO" = "2"))
  expect_equal(cambridge_parsed_sps$value_labels$V303,
               c("NOT POOR" = "1",
                 "POOR" = "2"))
  expect_equal(cambridge_parsed_sps$value_labels$V308,
               c("II" = "1",
                 "III" = "2",
                 "IV" = "3",
                 "V" = "4"))
  expect_equal(cambridge_parsed_sps$value_labels$V879,
               c("NK-UNASCERTAIN" = "0",
                 "PAY TAX" = "1",
                 "AVOID TAX ILLEGL" = "2"))
  expect_equal(cambridge_parsed_sps$value_labels$V418,
               c("NK-UNASCERTAIN" = "0",
                 "<=9 -FEW ERRS" = "1",
                 "10-13" = "2",
                 "14-18" = "3",
                 ">=19 -MANY ERRS" = "4"))
  expect_equal(cambridge_parsed_sps$value_labels$V419,
               c("NK-UNASCERTAIN" = "0",
                 "<=9 -HIGH TQ" = "1",
                 "10-12" = "2",
                 "13-15" = "3",
                 ">=16 -LOW TQ" = "4"))
  expect_equal(cambridge_parsed_sps$value_labels$V880,
               c("NK-UNASCERTAIN" = "0",
                 "NO" = "1",
                 "YES" = "2"))
})

test_that("Guam - parsed value labels are accurate", {

  expect_equal(head(names(guam_parsed_sps$value_labels)),
               c("RECTYPE",
                 "RESISTAT",
                 "STATEOCC",
                 "CONTYOCC",
                 "REGION",
                 "DIVISION"))
  expect_equal(tail(names(guam_parsed_sps$value_labels)),
               c("AGE_FLG",
                 "PLACEINJ",
                 "ICD282",
                 "ICD72",
                 "ICD61",
                 "ICD34"))

  expect_equal(guam_parsed_sps$value_labels$RECTYPE,
               c("RESIDENTS" = "1",
                 "NONRESIDENTS" = "2"))
  expect_equal(guam_parsed_sps$value_labels$RESISTAT,
               c("RESIDENTS" = "1",
                 "INTRASTATE NONRESIDENTS" = "2",
                 "INTERSTATE NONRESIDENTS" = "3",
                 "FOREIGN RESIDENTS" = "4"))
  expect_equal(guam_parsed_sps$value_labels$RACE_R2,
               c("White" = "1",
                 "All other races" = "2"))
  expect_equal(guam_parsed_sps$value_labels$AGE_FLG,
               c("Calculated age is substituted for reported age" = "1"))
  expect_equal(guam_parsed_sps$value_labels$FIPCNRES,
               c("Foreign residents" = "0",
                 "County less than 100,000 population" = "999"))
  expect_equal(guam_parsed_sps$value_labels$DAYDEATH,
               c("Sunday" = "1",
                 "Monday" = "2",
                 "Tuesday" = "3",
                 "Wednesday" = "4",
                 "Thursday" = "5",
                 "Friday" = "6",
                 "Saturday" = "7",
                 "Unknown" = "9"))
  expect_equal(guam_parsed_sps$value_labels$KINDBUSS,
               c("Own home/At home" = "961",
                 "Retired; with no other industry reported" = "970",
                 "Blank, Unknownr NA" = "990"))
  expect_equal(guam_parsed_sps$value_labels$USUALOCC,
               c("Retired; with no other occupation reported" = "913",
                 "Housewife/Homemaker" = "914",
                 "Student" = "915",
                 "Volunteer" = "916",
                 "Unemployed, never worked, disabled, child, infant" = "917",
                 "Blank, Unknown, NA" = "999"))
})


test_that("China 1995 - parsed value labels are accurate", {

  expect_equal(head(names(china_1995_parsed_sps$value_labels)),
               c("A3",
                 "A4",
                 "A6",
                 "A7",
                 "A8",
                 "A9"))
  expect_equal(tail(names(china_1995_parsed_sps$value_labels)),
               c("A39",
                 "A40",
                 "A41",
                 "A47",
                 "A48",
                 "A49"))

  expect_equal(china_1995_parsed_sps$value_labels$A3,
               c("self" = "1",
                 "spouse" = "2",
                 "child" = "3",
                 "child in law" = "4",
                 "grandchild" = "5",
                 "parent" = "6",
                 "parent in law" = "7",
                 "grandparent" = "8",
                 "brother or sister" = "9",
                 "other relative" = "10",
                 "non-relative" = "11"))
  expect_equal(china_1995_parsed_sps$value_labels$A4,
               c("male" = "1",
                 "female" = "2"))
  expect_equal(china_1995_parsed_sps$value_labels$A8,
               c("yes" = "1",
                 "no" = "2"))
  expect_equal(china_1995_parsed_sps$value_labels$A20,
               c("yes" = "1",
                 "no" = "2"))
  expect_equal(china_1995_parsed_sps$value_labels$A47,
               c("unknown code" = "0",
                 "an enterprise" = "1",
                 "a government organization or institution" = "2",
                 "other" = "3"))
  expect_equal(china_1995_parsed_sps$value_labels$A48,
               c("unknown code" = "0",
                 "yes" = "1",
                 "no" = "2"))
  expect_equal(china_1995_parsed_sps$value_labels$A49,
               c("unknown code" = "0",
                 "employed throughout the year" = "1",
                 "unemployed some of the time" = "2",
                 "unemployed throughout the year" = "3"))
})


test_that("China 2002 - parsed value labels are accurate", {

  expect_equal(head(names(china_2002_parsed_sps$value_labels)),
               c("V3_1",
                 "V3_2",
                 "V3_3",
                 "V3_4",
                 "V3_101",
                 "V3_102"))
  expect_equal(tail(names(china_2002_parsed_sps$value_labels)),
               c("V3_702",
                 "V3_701B",
                 "V3_702B",
                 "V3_703",
                 "V3_704",
                 "V3_705"))

  expect_equal(china_2002_parsed_sps$value_labels$V3_1,
               c("plain (basin)" = "1",
                 "hilly area" = "2",
                 "mountainous area" = "3"))
  expect_equal(china_2002_parsed_sps$value_labels$V3_2,
               c("Yes" = "1",
                 "No" = "2"))
  expect_equal(china_2002_parsed_sps$value_labels$V3_316D,
               c("the villager" = "1",
                 "the village cadre" = "2",
                 "the township cadre" = "3",
                 "the county (or upper level cadre)" = "4",
                 "others" = "5"))
  expect_equal(china_2002_parsed_sps$value_labels$V3_505A,
               c("Less than once per year" = "0"))
  expect_equal(china_2002_parsed_sps$value_labels$V3_506A,
               c("Less than once per year" = "0"))
  expect_equal(china_2002_parsed_sps$value_labels$V3_704,
               c("Yes" = "1",
                 "No" = "2"))
  expect_equal(china_2002_parsed_sps$value_labels$V3_705,
               c("Yes" = "1",
                 "No" = "2"))
})


test_that("China 1998 - parsed value labels are accurate", {

  expect_equal(head(names(china_1998_parsed_sps$value_labels)),
               c("RELATION",
                 "GENDER",
                 "AGE",
                 "STUDENT",
                 "INCOME88",
                 "RESIDENC"))
  expect_equal(tail(names(china_1998_parsed_sps$value_labels)),
               c("IT07T",
                 "IT07M",
                 "IT07E",
                 "IT08T",
                 "IT08M",
                 "IT08E"))

  expect_equal(china_1998_parsed_sps$value_labels$RELATION,
               c("Self" = "1",
                 "Spouse" = "2",
                 "Child" = "3",
                 "Grandchild" = "4",
                 "Parent" = "5",
                 "Grandparent" = "6",
                 "Other Relative" = "7",
                 "Not Related" = "8",
                 "Missing" = "9"))
  expect_equal(china_1998_parsed_sps$value_labels$GENDER,
               c("Male" = "0",
                 "Female" = "1",
                 "Missing" = "9"))
  expect_equal(china_1998_parsed_sps$value_labels$AGE,
               c("Missing" = "999"))
  expect_equal(china_1998_parsed_sps$value_labels$SJ,
               c("No" = "0",
                 "Yes" = "1",
                 "Missing" = "9"))
  expect_equal(china_1998_parsed_sps$value_labels$IT01T,
               c("Food" = "1",
                 "Daily Use Article" = "2",
                 "Consumer Durables" = "3",
                 "Other" = "4",
                 "Missing" = "9"))
  expect_equal(china_1998_parsed_sps$value_labels$IT08M,
               c("Missing" = "99999"))
  expect_equal(china_1998_parsed_sps$value_labels$IT08E,
               c("Missing" = "99999"))
})


test_that("UN Crime - parsed value labels are accurate", {

  expect_equal(head(names(UN_crime_parsed_sps$value_labels)),
               c("NNHOM70N",
                 "NNHOM71N",
                 "NNHOM72N",
                 "NNHOM73N",
                 "NNHOM74N",
                 "NNHOM75N"))
  expect_equal(tail(names(UN_crime_parsed_sps$value_labels)),
               c("PSTF745",
                 "X2",
                 "X3",
                 "X4",
                 "X5",
                 "X6"))

  expect_equal(UN_crime_parsed_sps$value_labels$NNHOM70N,
               c("Blank" = "-9"))
  expect_equal(UN_crime_parsed_sps$value_labels$ROB74,
               c("Blank" = "-9"))
  expect_equal(UN_crime_parsed_sps$value_labels$FRAUD72,
               c("Blank" = "-9"))
  expect_equal(UN_crime_parsed_sps$value_labels$TOTC70,
               c("Blank" = "-9"))
  expect_equal(UN_crime_parsed_sps$value_labels$TDRUG70N,
               c("Blank" = "-9"))
  expect_equal(UN_crime_parsed_sps$value_labels$ACON723,
               c("Blank" = "-9"))
  expect_equal(UN_crime_parsed_sps$value_labels$X6,
               c("Blank" = "-9"))
})

test_that("CCPS 2004 - parsed value labels are accurate", {


  expect_equal(cps_2004_parsed_sps$value_labels$HURESPLI,
               c("REFUSED" = "-3",
                 "DONT KNOW" = "-2",
                 "BLANK OR NOT IN UNIVERSE" = "-1"))
  expect_equal(cps_2004_parsed_sps$value_labels$HETELAVL,
               c("REFUSED" = "-3",
                 "DONT KNOW" = "-2",
                 "BLANK OR NOT IN UNIVERSE" = "-1",
                 "YES" = "1",
                 "NO" = "2"))
  expect_equal(cps_2004_parsed_sps$value_labels$HETELHHD,
               c("REFUSED" = "-3",
                 "DONT KNOW" = "-2",
                 "BLANK OR NOT IN UNIVERSE" = "-1",
                 "YES" = "1",
                 "NO" = "2"))
  expect_equal(cps_2004_parsed_sps$value_labels$PEIO1ICD,
               c("REFUSED" = "-3",
                 "DONT KNOW" = "-2",
                 "BLANK OR NOT IN UNIVERSE" = "-1"))
  expect_equal(cps_2004_parsed_sps$value_labels$PEIO1OCD,
               c("REFUSED" = "-3",
                 "DONT KNOW" = "-2",
                 "BLANK OR NOT IN UNIVERSE" = "-1"))
  expect_equal(cps_2004_parsed_sps$value_labels$HEQ3,
               c("No response" = "-9",
                 "Refused" = "-3",
                 "Dont know" = "-2",
                 "Blank or Not in Universe" = "-1",
                 "All or almost all calls," = "1",
                 "More than half," = "2",
                 "Less than half, or" = "3",
                 "Very few or none?" = "4"))
  expect_equal(cps_2004_parsed_sps$value_labels$HRSUPINT,
               c("Interview" = "1",
                 "Noninterview" = "2"))
})


test_that("Drug abuse - parsed value labels are accurate", {


  expect_equal(drug_abuse_parsed_sps$value_labels$ID,
               c("Missing" = "-9"))
  expect_equal(drug_abuse_parsed_sps$value_labels$RESPCODE,
               c("Missing" = "-9"))
  expect_equal(drug_abuse_parsed_sps$value_labels$ADDICTIONS_COUNSELING ,
               c("Missing" = "-9",
                 "Not Marked" = "0",
                 "Marked" = "1"))
  expect_equal(drug_abuse_parsed_sps$value_labels$BSOCA5,
               c("Blank / Not ascertained" = "-9",
                 "Disagree Strongly" = "1",
                 "Disagree" = "2",
                 "Uncertain" = "3",
                 "Agree" = "4",
                 "Agree Strongly" = "5"))
  expect_equal(drug_abuse_parsed_sps$value_labels$BSOCA6,
               c("Blank / Not ascertained" = "-9",
                 "Disagree Strongly" = "1",
                 "Disagree" = "2",
                 "Uncertain" = "3",
                 "Agree" = "4",
                 "Agree Strongly" = "5"))
  expect_equal(drug_abuse_parsed_sps$value_labels$EOTSCO,
               c("Missing" = "-9"))
  expect_equal(drug_abuse_parsed_sps$value_labels$EOTOPN    ,
               c("Missing" = "-9",
                 "Not calculated for respondent type" = "-5"))
})


test_that("Detroit - parsed value labels are accurate", {


  expect_equal(detroit_parsed_sps$value_labels$I_MONTH,
               c("January" = "1",
                 "February" = "2",
                 "March" = "3",
                 "April" = "4",
                 "May" = "5",
                 "June" = "6",
                 "July" = "7",
                 "August" = "8",
                 "September" = "9",
                 "October" = "10",
                 "November" = "11",
                 "December" = "12"))
  expect_equal(detroit_parsed_sps$value_labels$A1_YEAR,
               c("ALL OF LIFE" = "95",
                 "UNCODEABLE" = "97"))
  expect_equal(detroit_parsed_sps$value_labels$A1_MONTH,
               c("UNCODEABLE" = "97"))
  expect_equal(detroit_parsed_sps$value_labels$D11A,
               c("IDENTITY" = "1",
                 "NO" = "5",
                 "Uncodeable" = "7",
                 "Dont_Know" = "8",
                 "Refuse" = "9"))
  expect_equal(detroit_parsed_sps$value_labels$J1,
               c("VERY DARK" = "1",
                 "DARK" = "2",
                 "MEDIUM" = "3",
                 "LIGHT" = "4",
                 "VERY LIGHT" = "5",
                 "Uncodeable" = "7",
                 "Dont_Know" = "8",
                 "Refuse" = "9"))
  expect_equal(detroit_parsed_sps$value_labels$J5B,
               c("UNCODEABLE" = "97",
                 "DONT KNOW" = "98",
                 "REFUSE" = "99"))
  expect_equal(detroit_parsed_sps$value_labels$J7,
               c("IN PERSON" = "1",
                 "TELEPHONE" = "2",
                 "Uncodeable" = "7",
                 "Dont_Know" = "8",
                 "Refuse" = "9"))
})


test_that("Worry - parsed value labels are accurate", {


  expect_equal(worry_parsed_sps$value_labels$PRE1,
               c("Not at all serious problem" = "0",
                 "Somewhat serious problem" = "2",
                 "Moderately serious problem" = "4",
                 "Very serious problem" = "6"))
  expect_equal(worry_parsed_sps$value_labels$CONDITION ,
               c("At beginning" = "1",
                 "At end" = "2"))
  expect_equal(worry_parsed_sps$value_labels$C1,
               c("Not at all likely" = "0",
                 "Very likely" = 6))
  expect_equal(worry_parsed_sps$value_labels$G12,
               c("Just chance/no one is to blame" = "0",
                 "Someone at the hospital is to blame" = "6"))
  expect_equal(worry_parsed_sps$value_labels$G19,
               c("Just chance/no one is to blame" = "0",
                 "Someone at the hospital is to blame" = "6"))
  expect_equal(worry_parsed_sps$value_labels$HEALTH,
               c("Poor" = "1",
                 "Fair" = "2",
                 "Good" = "3",
                 "Excellent" = "4"))
  expect_equal(worry_parsed_sps$value_labels$EDUC,
               c("Less than high school" = "1",
                 "High school graduate" = "2",
                 "Some college" = "3",
                 "College graduate" = "4",
                 "Graduate degree" = "5"))
})


test_that("Census Police - parsed value labels are accurate", {


  expect_equal(census_police_parsed_sps$value_labels$AGCYTYPE,
               c("Local police department" = "0",
                 "Sheriffs office" = "1",
                 "Primary state law enforcement agency" = "5",
                 "Special jurisdiction" = "6",
                 "Constable/marshal" = "7"))
  expect_equal(census_police_parsed_sps$value_labels$SUBTYPE1,
               c("Public buildings/facilities" = "1",
                 "Natural resources/parks and recreation" = "2",
                 "Transportation systems/facilities" = "3",
                 "Criminal investigations" = "4",
                 "Special enforcement" = "5",
                 "Not applicable" = "888"))
  expect_equal(census_police_parsed_sps$value_labels$TRIBAL,
               c("Not a tribal agency" = "0",
                 "Yes, a tribal agency" = "1"))
  expect_equal(census_police_parsed_sps$value_labels$Q1A1,
               c("Blank" = "-9",
                 "Yes" = "1",
                 "No" = "2"))
  expect_equal(census_police_parsed_sps$value_labels$Q3EST,
               c("Blank" = "-9",
                 "Dont know" = "-2",
                 "Yes" = "1",
                 "No" = "2"))
  expect_equal(census_police_parsed_sps$value_labels$Q6I,
               c("Blank" = "-9"))
  expect_equal(census_police_parsed_sps$value_labels$Q6_TOT,
               c("Blank" = "-9"))
})


test_that("Step In - parsed value labels are accurate", {


  expect_equal(step_in_parsed_sps$value_labels$NR_DAYS,
               c("missing value (date of release (event 2) is unknown or client was still incarcerated at the time of data collection)" = "-99"))
  expect_equal(step_in_parsed_sps$value_labels$NO_RECORD,
               c("arrest data not available" = "1"))
  expect_equal(step_in_parsed_sps$value_labels$EVENT,
               c("arrest that leads to incarceration" = "1",
                 "release from jail/prison after arrest (EVENT 1)" = "2",
                 "arrest that does not lead to incarceration" = "3"))
  expect_equal(step_in_parsed_sps$value_labels$CHARGE,
               c("missing value: type of charge is unknown" = "-99",
                 "violent: use of dangerous weapon, robbery, assault, battery, homicide, attempted homicide, manslaughter, mugging, kidnap" = "1",
                 "property: theft, identity theft, burglary, possession stolen vehicle, unauthorized use of vehicle, credit card forgery," = "2",
                 "drug: drug possession, drug distribution, public intoxication, DUI, drug use, poss. to distribute, drug paraphernalia, m" = "3",
                 "parole violation" = "4",
                 "other: failure to appear, possession of firearm, harassment, criminal driving, false police report, child endangerment," = "5",
                 "sex: prostitution, pimping, rape, sexual assault, sex w/minor" = "6"))
})


test_that("India human - parsed value labels are accurate", {


  expect_equal(india_human_parsed_sps$value_labels$SURVEY,
               c("IHDS-I 1" = "1",
                 "IHDS-II 2" = "2"))
  expect_equal(india_human_parsed_sps$value_labels$CS18,
               c("Voc: <1 yr 1" = "1",
                 "Voc: 1-2 years 2" = "2",
                 "Voc: 3+ years 3" = "3",
                 "Others 4" = "4"))
  expect_equal(india_human_parsed_sps$value_labels$CS19,
               c("Govt. 1" = "1",
                 "Private 2" = "2"))
  expect_equal(india_human_parsed_sps$value_labels$MG11,
               c("Contractor 1" = "1",
                 "With a job or Self Employed 2" = "2",
                 "Without a job 3" = "3"))
  expect_equal(india_human_parsed_sps$value_labels$MM13,
               c("No 0" = "0",
                 "Yes 1" = "1"))
  expect_equal(india_human_parsed_sps$value_labels$TA6,
               c("Nicely 1" = "1",
                 "Somewhat nicely 2" = "2",
                 "Not nicely 3" = "3"))
  expect_equal(india_human_parsed_sps$value_labels$MGYEAR1,
               c("No 0" = "0",
                 "Yes 1" = "1"))
})


test_that("Health and Nutrition - parsed value labels are accurate", {


  expect_equal(health_nutrition_parsed_sps$value_labels$SDDSRVYR,
               c("NHANES 2005-2006 Public Release" = "4"))
  expect_equal(health_nutrition_parsed_sps$value_labels$RIAGENDR,
               c("Male" = "1",
                 "Female" = "2"))
  expect_equal(health_nutrition_parsed_sps$value_labels$DMDCITZN,
               c("Citizen by birth or naturalization" = "1",
                 "Not a citizen of the US" = "2",
                 "Refused" = "7",
                 "Dont know" = "9"))
  expect_equal(health_nutrition_parsed_sps$value_labels$DMDEDUC3,
               c("Never Attended / Kindergarten Only" = "0",
                 "1st Grade" = "1",
                 "2nd Grade" = "2",
                 "3rd Grade" = "3",
                 "4th Grade" = "4",
                 "5th Grade" = "5",
                 "6th Grade" = "6",
                 "7th Grade" = "7",
                 "8th Grade" = "8",
                 "9th Grade" = "9",
                 "10th Grade" = "10",
                 "11th Grade" = "11",
                 "12th Grade, No Diploma" = "12",
                 "High School Graduate" = "13",
                 "GED or Equivalent" = "14",
                 "More than high school" = "15",
                 "Less Than 5th Grade" = "55",
                 "Less Than 9th Grade" = "66",
                 "Refused" = "77",
                 "Dont know" = "99"))
  expect_equal(health_nutrition_parsed_sps$value_labels$DMDHRBRN,
               c("Born in 50 US States or Washington, DC" = "1",
                 "Born in Mexico" = "2",
                 "Born Elsewhere" = "3",
                 "Refused" = "7",
                 "Dont know" = "9"))
  expect_equal(health_nutrition_parsed_sps$value_labels$SIAINTRP,
               c("Yes" = "1",
                 "No" = "2"))
  expect_equal(health_nutrition_parsed_sps$value_labels$AIALANG,
               c("English" = "1",
                 "Spanish" = "2"))
})

test_that("SHR1981 - parsed value labels are accurate", {
  expect_equal(SHR1981_parsed_sps$value_labels$V1,
               c("ICPSR Study Number" = "9028"))
  expect_equal(SHR1981_parsed_sps$value_labels$V2,
               c("Second edition, February 1994" = "2"))
  expect_equal(SHR1981_parsed_sps$value_labels$V3,
               c("Part 7: SHR 1981" = "7"))
  expect_equal(SHR1981_parsed_sps$value_labels$V5,
               c("SHR master file" = "6"))
  expect_equal(SHR1981_parsed_sps$value_labels$V6,
               c("Alabama" = "01",
                 "Arizona" = "02",
                 "Arkansas" = "03",
                 "California" = "04",
                 "Colorado" = "05",
                 "Connecticut" = "06",
                 "Delaware" = "07",
                 "Washington, D.C" = "08",
                 "Florida" = "09",
                 "Georgia" = "10",
                 "Idaho" = "11",
                 "Illinois" = "12",
                 "Indiana" = "13",
                 "Iowa" = "14",
                 "Kansas" = "15",
                 "Kentucky" = "16",
                 "Louisiana" = "17",
                 "Maine" = "18",
                 "Maryland" = "19",
                 "Massachusetts" = "20",
                 "Michigan" = "21",
                 "Minnesota" = "22",
                 "Mississippi" = "23",
                 "Missouri" = "24",
                 "Montana" = "25",
                 "Nebraska" = "26",
                 "Nevada" = "27",
                 "New Hampshire" = "28",
                 "New Jersey" = "29",
                 "New Mexico" = "30",
                 "New York" = "31",
                 "North Carolina" = "32",
                 "North Dakota" = "33",
                 "Ohio" = "34",
                 "Oklahoma" = "35",
                 "Oregon" = "36",
                 "Pennsylvania" = "37",
                 "Rhode Island" = "38",
                 "South Carolina" = "39",
                 "South Dakota" = "40",
                 "Tennessee" = "41",
                 "Texas" = "42",
                 "Utah" = "43",
                 "Vermont" = "44",
                 "Virginia" = "45",
                 "Washington" = "46",
                 "West Virginia" = "47",
                 "Wisconsin" = "48",
                 "Wyoming" = "49",
                 "Alaska" = "50",
                 "Hawaii" = "51",
                 "Canal Zone" = "52",
                 "Puerto Rico" = "53",
                 "American Samoa" = "54",
                 "Guam" = "55",
                 "Virgin Islands" = "62"))
  expect_equal(SHR1981_parsed_sps$value_labels$V8,
               c("Possessions" = "0",
                 "All cities 1,000,000 or over" = "11",
                 "Cities 500,000 thru 999,999" = "12",
                 "Cities 250,000 thru 499,999" = "13",
                 "Cities 100,000 thru 249,999" = "20",
                 "Cities 50,000 thru 99,999" = "30",
                 "Cities 25,000 thru 49,999" = "40",
                 "Cities 10,000 thru 24,999" = "50",
                 "Cities 2,500 thru 9,999" = "60",
                 "Cities under 2,500" = "70",
                 "Non-MSA counties 100,000 or over" = "81",
                 "Non-MSA counties 25,000 thru 99,999" = "82",
                 "Non-MSA counties 10,000 thru 24,999" = "83",
                 "Non-MSA counties under 10,000" = "84",
                 "Non-MSA State Police" = "85",
                 "MSA counties 100,000 or over" = "91",
                 "MSA counties 25,000 thru 99,999" = "92",
                 "MSA counties 10,000 thru 24,999" = "93",
                 "MSA counties under 10,000" = "94",
                 "MSA State Police" = "95"))
  expect_equal(SHR1981_parsed_sps$value_labels$V9,
               c("Possessions" = "0",
                 "New England States" = "1",
                 "Middle Atlantic States" = "2",
                 "East North Central States" = "3",
                 "West North Central States" = "4",
                 "South Atlantic States" = "5",
                 "East South Central States" = "6",
                 "West South Central States" = "7",
                 "Mountain States" = "8",
                 "Pacific States" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V10,
               c("1981" = "81"))
  expect_equal(SHR1981_parsed_sps$value_labels$V11,
               c("Unknown or not reported" = "0"))
  expect_equal(SHR1981_parsed_sps$value_labels$V12,
               c("Inapplicable" = "0"))
  expect_equal(SHR1981_parsed_sps$value_labels$V13,
               c("Inapplicable" = "0"))
  expect_equal(SHR1981_parsed_sps$value_labels$V14,
               c("Non-suburban" = "0",
                 "Suburban" = "1"))
  expect_equal(SHR1981_parsed_sps$value_labels$V17,
               c("January" = "1",
                 "February" = "2",
                 "March" = "3",
                 "April" = "4",
                 "May" = "5",
                 "June" = "6",
                 "July" = "7",
                 "August" = "8",
                 "September" = "9",
                 "October" = "10",
                 "November" = "11",
                 "December" = "12"))
  expect_equal(SHR1981_parsed_sps$value_labels$V20,
               c("Murder and non-negligent manslaughter" = "1",
                 "Manslaughter by negligence" = "2"))
  expect_equal(SHR1981_parsed_sps$value_labels$V22,
               c("Single victim/single offender" = "1",
                 "Single victim/unknown offender(s)" = "2",
                 "Single victim/multiple offenders" = "3",
                 "Multiple victims/single offender" = "4",
                 "Multiple victims/multiple offenders" = "5",
                 "Multiple victims/unknown offender(s)" = "6"))
  expect_equal(SHR1981_parsed_sps$value_labels$V25,
               c("Birth to 6 days old" = "100",
                 "7 days old to 364 days old" = "101",
                 "1 year old" = "1",
                 "99 years old or more" = "99",
                 "Unknown" = "999",
                 "Out of Universe" = "900"))
  expect_equal(SHR1981_parsed_sps$value_labels$V26,
               c("Male" = "1",
                 "Female" = "2",
                 "Unknown" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V27,
               c("White" = "1",
                 "Black" = "2",
                 "American Indian or Alaskan Native" = "3",
                 "Asian or Pacific Islander" = "4",
                 "Unknown" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V28,
               c("Hispanic origin" = "1",
                 "Not of Hispanic origin" = "2",
                 "Unknown" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V29,
               c("Birth to 6 days old" = "100",
                 "7 days old to 364 days old" = "101",
                 "1 year old" = "001",
                 "99 years old or more" = "099",
                 "Inap, only one victim" = "998",
                 "Unknown" = "999"))
  expect_equal(SHR1981_parsed_sps$value_labels$V30,
               c("Male" = "1",
                 "Female" = "2",
                 "Inap, only one victim" = "8",
                 "Unknown" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V31,
               c("White" = "1",
                 "Black" = "2",
                 "American Indian or Alaskan Native" = "3",
                 "Asian or Pacific Islander" = "4",
                 "Inap, only one victim" = "8",
                 "Unknown" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V32,
               c("Hispanic origin" = "1",
                 "Not of Hispanic origin" = "2",
                 "Inap, only one victim" = "8",
                 "Unknown" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V33,
               c("Birth to 6 days old" = "100",
                 "7 days old to 364 days old" = "101",
                 "1 year old" = "001",
                 "99 years old or more" = "099",
                 "Inap, less than 3 victims" = "998",
                 "Unknown" = "999"))
  expect_equal(SHR1981_parsed_sps$value_labels$V34,
               c("Male" = "1",
                 "Female" = "2",
                 "Inap, less than 3 victims" = "8",
                 "Unknown" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V69,
               c("Age unknown" = "999"))
  expect_equal(SHR1981_parsed_sps$value_labels$V73,
               c("Firearm, type not stated" = "11",
                 "Handgun - pistol, revolver, etc" = "12",
                 "Rifle" = "13",
                 "Shotgun" = "14",
                 "Other gun" = "15",
                 "Knife or cutting instrument" = "20",
                 "Blunt object" = "30",
                 "Personal weapons" = "40",
                 "Poison - does not include gas" = "50",
                 "Pushed or thrown out window" = "55",
                 "Explosives" = "60",
                 "Fire" = "65",
                 "Narcotics or drugs" = "70",
                 "Drowning" = "75",
                 "Strangulation - hanging" = "80",
                 "Asphyxiation - includes death by gas" = "85",
                 "Other - type of weapon not designated" = "90"))
  expect_equal(SHR1981_parsed_sps$value_labels$V74,
               c("Husband" = "01",
                 "Wife" = "02",
                 "Common-law husband" = "03",
                 "Common-law wife" = "04",
                 "Mother" = "05",
                 "Father" = "06",
                 "Son" = "07",
                 "Daughter" = "08",
                 "Brother" = "09",
                 "Sister" = "10",
                 "In-law" = "11",
                 "Stepfather" = "12",
                 "Stepmother" = "13",
                 "Stepson" = "14",
                 "Stepdaughter" = "15",
                 "Other family" = "16",
                 "Neighbor" = "17",
                 "Acquaintance" = "18",
                 "Boyfriend" = "19",
                 "Girlfriend" = "20",
                 "Ex-husband" = "21",
                 "Ex-wife" = "22",
                 "Employee" = "23",
                 "Employer" = "24",
                 "Friend" = "25",
                 "Homosexual relationship" = "26",
                 "Other - known to victim" = "27",
                 "Stranger" = "28",
                 "Relationship not determined" = "99"))
  expect_equal(SHR1981_parsed_sps$value_labels$V75,
               c("Rape" = "02",
                 "Robbery" = "03",
                 "Burglary" = "05",
                 "Larceny" = "06",
                 "Motor vehicle theft" = "07",
                 "Arson" = "09",
                 "Prostitution and commercialized vice" = "10",
                 "Other sex offense" = "17",
                 "Abortion" = "32",
                 "Narcotic drug laws" = "18",
                 "Gambling" = "19",
                 "Other - not specified" = "26",
                 "Lover s triangle" = "40",
                 "Child killed by babysitter" = "41",
                 "Brawl due to influence of alcohol" = "42",
                 "Brawl due to influence of narcotics" = "43",
                 "Argument over money or property" = "44",
                 "Other arguments" = "45",
                 "Gangland killings" = "46",
                 "Juvenile gang killings" = "47",
                 "Institutional killings" = "48",
                 "Sniper attack" = "49",
                 "Other" = "60",
                 "All suspected felony type" = "70",
                 "Felon killed by private citizen" = "80",
                 "Felon killed by police" = "81",
                 "Circumstances undetermined" = "99"))
  expect_equal(SHR1981_parsed_sps$value_labels$V76,
               c("Felon attacked police officer" = "1",
                 "Felon attacked fellow police officer" = "2",
                 "Felon attacked a civilian" = "3",
                 "Felon attempted flight from a crime" = "4",
                 "Felon killed in commission of a crime" = "5",
                 "Felon resisted arrest" = "6",
                 "Not enough information to determine" = "7",
                 "Inap, not a justifiable homicide" = "9"))
  expect_equal(SHR1981_parsed_sps$value_labels$V77,
               c("Inap, only one offender" = "998",
                 "Unknown" = "999"))
})


test_that("ACS - parsed value labels are accurate", {
  expect_equal(acs_parsed_sps$value_labels$STATEFIP,
               c("Alabama" = "01",
                 "Alaska" = "02",
                 "Arizona" = "04",
                 "Arkansas" = "05",
                 "California" = "06",
                 "Colorado" = "08",
                 "Connecticut" = "09",
                 "Delaware" = "10",
                 "District of Columbia" = "11",
                 "Florida" = "12",
                 "Georgia" = "13",
                 "Hawaii" = "15",
                 "Idaho" = "16",
                 "Illinois" = "17",
                 "Indiana" = "18",
                 "Iowa" = "19",
                 "Kansas" = "20",
                 "Kentucky" = "21",
                 "Louisiana" = "22",
                 "Maine" = "23",
                 "Maryland" = "24",
                 "Massachusetts" = "25",
                 "Michigan" = "26",
                 "Minnesota" = "27",
                 "Mississippi" = "28",
                 "Missouri" = "29",
                 "Montana" = "30",
                 "Nebraska" = "31",
                 "Nevada" = "32",
                 "New Hampshire" = "33",
                 "New Jersey" = "34",
                 "New Mexico" = "35",
                 "New York" = "36",
                 "North Carolina" = "37",
                 "North Dakota" = "38",
                 "Ohio" = "39",
                 "Oklahoma" = "40",
                 "Oregon" = "41",
                 "Pennsylvania" = "42",
                 "Rhode Island" = "44",
                 "South Carolina" = "45",
                 "South Dakota" = "46",
                 "Tennessee" = "47",
                 "Texas" = "48",
                 "Utah" = "49",
                 "Vermont" = "50",
                 "Virginia" = "51",
                 "Washington" = "53",
                 "West Virginia" = "54",
                 "Wisconsin" = "55",
                 "Wyoming" = "56",
                 "Maine-New Hampshire-Vermont" = "61",
                 "Massachusetts-Rhode Island" = "62",
                 "Minnesota-Iowa-Missouri-Kansas-Nebraska-S.Dakota-N.Dakota" = "63",
                 "Maryland-Delaware" = "64",
                 "Montana-Idaho-Wyoming" = "65",
                 "Utah-Nevada" = "66",
                 "Arizona-New Mexico" = "67",
                 "Alaska-Hawaii" = "68",
                 "Puerto Rico" = "72",
                 "Military/Mil. Reservation" = "97",
                 "State not identified" = "99"))
  expect_equal(acs_parsed_sps$value_labels$GQ,
               c("Vacant unit" = "0",
                 "Households under 1970 definition" = "1",
                 "Additional households under 1990 definition" = "2",
                 "Group quarters--Institutions" = "3",
                 "Other group quarters" = "4",
                 "Additional households under 2000 definition" = "5",
                 "Fragment" = "6"))
  expect_equal(acs_parsed_sps$value_labels$SEX,
               c("Male" = "1",
                 "Female" = "2"))
  expect_equal(acs_parsed_sps$value_labels$AGE,
               c("Less than 1 year old" = "000",
                 "1" = "001",
                 "2" = "002",
                 "3" = "003",
                 "4" = "004",
                 "5" = "005",
                 "6" = "006",
                 "7" = "007",
                 "8" = "008",
                 "9" = "009",
                 "10" = "010",
                 "11" = "011",
                 "12" = "012",
                 "13" = "013",
                 "14" = "014",
                 "15" = "015",
                 "16" = "016",
                 "17" = "017",
                 "18" = "018",
                 "19" = "019",
                 "20" = "020",
                 "21" = "021",
                 "22" = "022",
                 "23" = "023",
                 "24" = "024",
                 "25" = "025",
                 "26" = "026",
                 "27" = "027",
                 "28" = "028",
                 "29" = "029",
                 "30" = "030",
                 "31" = "031",
                 "32" = "032",
                 "33" = "033",
                 "34" = "034",
                 "35" = "035",
                 "36" = "036",
                 "37" = "037",
                 "38" = "038",
                 "39" = "039",
                 "40" = "040",
                 "41" = "041",
                 "42" = "042",
                 "43" = "043",
                 "44" = "044",
                 "45" = "045",
                 "46" = "046",
                 "47" = "047",
                 "48" = "048",
                 "49" = "049",
                 "50" = "050",
                 "51" = "051",
                 "52" = "052",
                 "53" = "053",
                 "54" = "054",
                 "55" = "055",
                 "56" = "056",
                 "57" = "057",
                 "58" = "058",
                 "59" = "059",
                 "60" = "060",
                 "61" = "061",
                 "62" = "062",
                 "63" = "063",
                 "64" = "064",
                 "65" = "065",
                 "66" = "066",
                 "67" = "067",
                 "68" = "068",
                 "69" = "069",
                 "70" = "070",
                 "71" = "071",
                 "72" = "072",
                 "73" = "073",
                 "74" = "074",
                 "75" = "075",
                 "76" = "076",
                 "77" = "077",
                 "78" = "078",
                 "79" = "079",
                 "80" = "080",
                 "81" = "081",
                 "82" = "082",
                 "83" = "083",
                 "84" = "084",
                 "85" = "085",
                 "86" = "086",
                 "87" = "087",
                 "88" = "088",
                 "89" = "089",
                 "90 (90+ in 1980 and 1990)" = "090",
                 "91" = "091",
                 "92" = "092",
                 "93" = "093",
                 "94" = "094",
                 "95" = "095",
                 "96" = "096",
                 "97" = "097",
                 "98" = "098",
                 "99" = "099",
                 "100 (100+ in 1960-1970)" = "100",
                 "101" = "101",
                 "102" = "102",
                 "103" = "103",
                 "104" = "104",
                 "105" = "105",
                 "106" = "106",
                 "107" = "107",
                 "108" = "108",
                 "109" = "109",
                 "110" = "110",
                 "111" = "111",
                 "112 (112+ in the 1980 internal data)" = "112",
                 "113" = "113",
                 "114" = "114",
                 "115 (115+ in the 1990 internal data)" = "115",
                 "116" = "116",
                 "117" = "117",
                 "118" = "118",
                 "119" = "119",
                 "120" = "120",
                 "121" = "121",
                 "122" = "122",
                 "123" = "123",
                 "124" = "124",
                 "125" = "125",
                 "126" = "126",
                 "129" = "129",
                 "130" = "130",
                 "135" = "135"))

})


test_that("crosswalk - parsed value labels are accurate", {
  expect_equal(crosswalk_parsed_sps$value_labels$SOURCE,
               c("Other" = "0",
                 "UCR only" = "1",
                 "DLEA only" = "2",
                 "UCR and DLEA" = "3"))
  expect_equal(crosswalk_parsed_sps$value_labels$UORI,
               c("Unknown" = "M"))
  expect_equal(crosswalk_parsed_sps$value_labels$UCORI,
               c("ORI rpts thru other ORI" = "*"))
  expect_equal(crosswalk_parsed_sps$value_labels$UMULTICO,
               c("ORI in > 1 county" = "*"))
  expect_equal(crosswalk_parsed_sps$value_labels$UCOUNTY,
               c("Inap" = "0",
                 "Unknown" = "999"))
  expect_equal(crosswalk_parsed_sps$value_labels$UMSA,
               c("Inap" = "0",
                 "Unknown/ not an MSA" = "999"))
  expect_equal(crosswalk_parsed_sps$value_labels$UPOPGRP,
               c("Unknown" = "M",
                 "Possessions" = "0",
                 "All cities 250,000 or over" = "1",
                 "Cities 1,000,000 or over" = "1A",
                 "Cities from 500,000 thru 999,000" = "1B",
                 "Cities from 250,000 thru 499,999" = "1C",
                 "Cities from 100,000 thru 249,000" = "2",
                 "Cities from 50,000 thru 99,999" = "3",
                 "Cities from 25,000 thru 49,999" = "4",
                 "Cities from 10,000 thru 24,999" = "5",
                 "Cities from 2,500 thru 9,999" = "6",
                 "Cities under 2,500" = "7",
                 "Non-MSA counties" = "8",
                 "Non-MSA counties 100,000 or over" = "8A",
                 "Non-MSA counties from 25,000 thru 99,999" = "8B",
                 "Non-MSA counties from 10,000 thru 24,999" = "8C",
                 "Non-MSA counties under 10,000" = "8D",
                 "Non-MSA State Police" = "8E",
                 "MSA counties" = "9",
                 "MSA counties 100,000 or over" = "9A",
                 "MSA counties from 25,000 thru 99,999" = "9B",
                 "MSA counties from 10,000 thru 24,999" = "9C",
                 "MSA counties under 10,000" = "9D",
                 "MSA State Police" = "9E"))
  expect_equal(crosswalk_parsed_sps$value_labels$UPOPCOV,
               c("Unknown" = "9999999"))
  expect_equal(crosswalk_parsed_sps$value_labels$UADD5,
               c("Unknown" = "99999"))
  expect_equal(crosswalk_parsed_sps$value_labels$CGOVIDNU,
               c("Unknown" = "999999999"))
  expect_equal(crosswalk_parsed_sps$value_labels$CGOVTYPE,
               c("State" = "0",
                 "County" = "1",
                 "Municipal" = "2",
                 "Township" = "3",
                 "Special district" = "4",
                 "Independent school district" = "5",
                 "Federal agency" = "6",
                 "Tribal" = "7",
                 "Railroad police" = "8",
                 "College/university" = "9",
                 "Unknown" = "99"))
  expect_equal(crosswalk_parsed_sps$value_labels$CPOP94,
               c("Unknown" = "99999999"))
  expect_equal(crosswalk_parsed_sps$value_labels$FSTATE,
               c("Alabama" = "1",
                 "Alaska" = "2",
                 "Arizona" = "4",
                 "Arkansas" = "5",
                 "California" = "6",
                 "Colorado" = "8",
                 "Connecticut" = "9",
                 "Delaware" = "10",
                 "District of Columbia" = "11",
                 "Florida" = "12",
                 "Georgia" = "13",
                 "Hawaii" = "15",
                 "Idaho" = "16",
                 "Illinois" = "17",
                 "Indiana" = "18",
                 "Iowa" = "19",
                 "Kansas" = "20",
                 "Kentucky" = "21",
                 "Louisiana" = "22",
                 "Maine" = "23",
                 "Maryland" = "24",
                 "Massachusetts" = "25",
                 "Michigan" = "26",
                 "Minnesota" = "27",
                 "Mississippi" = "28",
                 "Missouri" = "29",
                 "Montana" = "30",
                 "Nebraska" = "31",
                 "Nevada" = "32",
                 "New Hampshire" = "33",
                 "New Jersey" = "34",
                 "New Mexico" = "35",
                 "New York" = "36",
                 "North Carolina" = "37",
                 "North Dakota" = "38",
                 "Ohio" = "39",
                 "Oklahoma" = "40",
                 "Oregon" = "41",
                 "Pennsylvania" = "42",
                 "Rhode Island" = "44",
                 "South Carolina" = "45",
                 "South Dakota" = "46",
                 "Tennessee" = "47",
                 "Texas" = "48",
                 "Utah" = "49",
                 "Vermont" = "50",
                 "Virginia" = "51",
                 "Washington" = "53",
                 "West Virginia" = "54",
                 "Wisconsin" = "55",
                 "Wyoming" = "56",
                 "Guam" = "66",
                 "Puerto Rico" = "72",
                 "Unknown" = "99"))
  expect_equal(crosswalk_parsed_sps$value_labels$FCOUNTY,
               c("Unknown" = "999"))
  expect_equal(crosswalk_parsed_sps$value_labels$FPLACE,
               c("Tribes" = "97000",
                 "State HQ" = "98000",
                 "Unknown" = "999999"))
  expect_equal(crosswalk_parsed_sps$value_labels$FMSA,
               c("Unknown/ no MSA" = "9999"))
  expect_equal(crosswalk_parsed_sps$value_labels$FCMSA,
               c("Unknown" = "999"))


})


test_that("UCR1960 - parsed value labels are accurate", {
  expect_equal(ucr1960_parsed_sps$value_labels$V1,
               c("Offenses known" = "1"))
  expect_equal(ucr1960_parsed_sps$value_labels$V2,
               c("Alabama" = "1",
                 "Arizona" = "2",
                 "Arkansas" = "3",
                 "California" = "4",
                 "Colorado" = "5",
                 "Connecticut" = "6",
                 "Delaware" = "7",
                 "District of Columbia" = "8",
                 "Florida" = "9",
                 "Georgia" = "10",
                 "Idaho" = "11",
                 "Illinois" = "12",
                 "Indiana" = "13",
                 "Iowa" = "14",
                 "Kansas" = "15",
                 "Kentucky" = "16",
                 "Louisiana" = "17",
                 "Maine" = "18",
                 "Maryland" = "19",
                 "Massachusetts" = "20",
                 "Michigan" = "21",
                 "Minnesota" = "22",
                 "Mississippi" = "23",
                 "Missouri" = "24",
                 "Montana" = "25",
                 "Nebraska" = "26",
                 "Nevada" = "27",
                 "New Hampshire" = "28",
                 "New Jersey" = "29",
                 "New Mexico" = "30",
                 "New York" = "31",
                 "North Carolina" = "32",
                 "North Dakota" = "33",
                 "Ohio" = "34",
                 "Oklahoma" = "35",
                 "Oregon" = "36",
                 "Pennsylvania" = "37",
                 "Rhode Island" = "38",
                 "South Carolina" = "39",
                 "South Dakota" = "40",
                 "Tennessee" = "41",
                 "Texas" = "42",
                 "Utah" = "43",
                 "Vermont" = "44",
                 "Virginia" = "45",
                 "Washington" = "46",
                 "West Virginia" = "47",
                 "Wisconsin" = "48",
                 "Wyoming" = "49",
                 "Alaska" = "50",
                 "Hawaii" = "51",
                 "Canal Zone" = "52",
                 "Puerto Rico" = "53",
                 "American Samoa" = "54",
                 "Guam" = "55",
                 "Virgin Islands" = "62"))
  expect_equal(ucr1960_parsed_sps$value_labels$V4,
               c("Possessions" = "0",
                 "ALL cit 250,000 +" = "1",
                 "Cit 1,000,000 +" = "1A",
                 "Cit 500,000-999,999" = "1B",
                 "Cit 250,000-499,999" = "1C",
                 "Cit 100,000-249,999" = "2",
                 "Cit 50,000-99,999" = "3",
                 "Cit 25,000-49,999" = "4",
                 "Cit 10,000-24,999" = "5",
                 "Cit 2,500-9,999" = "6",
                 "Cit < 2,500" = "7",
                 "Non-MSA co." = "8",
                 "Non-MSA co. 100,000 +" = "8A",
                 "Non-MSA co. 25,000-99,999" = "8B",
                 "Non-MSA co. 10,000-24,999" = "8C",
                 "Non-MSA co. < 10,000" = "8D",
                 "Non-MSA St Police" = "8E",
                 "MSA counties" = "9",
                 "MSA co. 100,000 +" = "9A",
                 "MSA co. 25,000-99,999" = "9B",
                 "MSA co. 10,000-24,999" = "9C",
                 "MSA co. < 10,000" = "9D",
                 "MSA St Police" = "9E"))
  expect_equal(ucr1960_parsed_sps$value_labels$V5,
               c("Possessions" = "0",
                 "New Eng1and States" = "1",
                 "Middle Atlantic States" = "2",
                 "East North Central States" = "3",
                 "West North Central States" = "4",
                 "South Atlantic States" = "5",
                 "East South Central States" = "6",
                 "West South Central States" = "7",
                 "Mountain States" = "8",
                 "Pacific States" = "9"))
  expect_equal(ucr1960_parsed_sps$value_labels$V8,
               c("No, not core city of MSA" = "N",
                 "Yes, core city of MSA" = "Y"))
  expect_equal(ucr1960_parsed_sps$value_labels$V12,
               c("No months reported" = "0",
                 "Jan last reported" = "1",
                 "Feb last reported" = "2",
                 "March last reported" = "3",
                 "April last reported" = "4",
                 "May last reported" = "5",
                 "June last reported" = "6",
                 "July last reported" = "7",
                 "August last reported" = "8",
                 "Sep last reported" = "9",
                 "Oct last reported" = "10",
                 "Nov last reported" = "11",
                 "Dec last reported" = "12"))
  expect_equal(ucr1960_parsed_sps$value_labels$V13,
               c("US Park & State Police" = "0",
                 "All other agencies" = "1"))
  expect_equal(ucr1960_parsed_sps$value_labels$V23,
               c("No, do not send a follow-up" = "N",
                 "Yes, send a follow-up" = "Y"))
  expect_equal(ucr1960_parsed_sps$value_labels$V24,
               c("Not special mail group agency" = "0",
                 "Return sent to another agency" = "1",
                 "Small city sent a large city form" = "2",
                 "Agency-non-contributor, not sent form" = "7",
                 "Agency-contributor, not on mail list" = "9"))
  expect_equal(ucr1960_parsed_sps$value_labels$V25,
               c("Not a special mailing address" = "N",
                 "Special mailing address" = "Y"))
  expect_equal(ucr1960_parsed_sps$value_labels$V33,
               c("Jan not w oth month" = "0",
                 "Reported with Jan" = "1",
                 "Reported with Feb" = "2",
                 "Reported with Mar" = "3",
                 "Reported with Apr" = "4",
                 "Reported with May" = "5",
                 "Reported with Jun" = "6",
                 "Reported with Jul" = "7",
                 "Reported with Aug" = "8",
                 "Reported with Sep" = "9",
                 "Reported with Oct" = "10",
                 "Reported with Nov" = "11",
                 "Reported with Dec" = "12"))
  expect_equal(ucr1960_parsed_sps$value_labels$V34,
               c("Not updated" = "0"))
  expect_equal(ucr1960_parsed_sps$value_labels$V35,
               c("Not updated" = "0",
                 "Adjustment" = "2",
                 "Not available" = "4",
                 "Normal return" = "5"))
  expect_equal(ucr1960_parsed_sps$value_labels$V36,
               c("Not updated" = "0",
                 "Adjustment" = "2",
                 "Not available" = "4",
                 "Normal return" = "5"))
  expect_equal(ucr1960_parsed_sps$value_labels$V160,
               c("No return received" = " ",
                 "Missing" = "0",
                 "Breakdown offenses" = "P",
                 "Totals only" = "T"))
  expect_equal(ucr1960_parsed_sps$value_labels$V270,
               c("Not updated" = "0"))
  expect_equal(ucr1960_parsed_sps$value_labels$V506,
               c("Not updated" = "0"))
  expect_equal(ucr1960_parsed_sps$value_labels$V509,
               c("Not updated" = "0",
                 "Adjustment" = "2",
                 "Not available" = "4",
                 "Normal return" = "5"))
  expect_equal(ucr1960_parsed_sps$value_labels$V512,
               c("No return received" = " ",
                 "Missing" = "0",
                 "Breakdown offenses" = "P",
                 "Totals only" = "T"))
  expect_equal(ucr1960_parsed_sps$value_labels$V1341,
               c("No return received" = " ",
                 "Missing" = "0",
                 "Breakdown offenses" = "P",
                 "Totals only" = "T"))

})


test_that("nibrs - parsed value labels are accurate", {
  expect_equal(nibrs_parsed_sps$value_labels$B1001,
               c("Batch header 1" = "B1"))
  expect_equal(nibrs_parsed_sps$value_labels$B1002,
               c("AK" = "50",
                 "AL" = "01",
                 "AR" = "03",
                 "AS" = "54",
                 "AZ" = "02",
                 "CA" = "04",
                 "CO" = "05",
                 "CT" = "06",
                 "CZ" = "52",
                 "DC" = "08",
                 "DE" = "07",
                 "FL" = "09",
                 "GA" = "10",
                 "GM" = "55",
                 "HI" = "51",
                 "IA" = "14",
                 "ID" = "11",
                 "IL" = "12",
                 "IN" = "13",
                 "KS" = "15",
                 "KY" = "16",
                 "LA" = "17",
                 "MA" = "20",
                 "MD" = "19",
                 "ME" = "18",
                 "MI" = "21",
                 "MN" = "22",
                 "MO" = "24",
                 "MS" = "23",
                 "MT" = "25",
                 "NB" = "26",
                 "NC" = "32",
                 "ND" = "33",
                 "NH" = "28",
                 "NJ" = "29",
                 "NM" = "30",
                 "NV" = "27",
                 "NY" = "31",
                 "OH" = "34",
                 "OK" = "35",
                 "OR" = "36",
                 "PA" = "37",
                 "PR" = "53",
                 "RI" = "38",
                 "SC" = "39",
                 "SD" = "40",
                 "TN" = "41",
                 "TX" = "42",
                 "UT" = "43",
                 "VI" = "62",
                 "VA" = "45",
                 "VT" = "44",
                 "WA" = "46",
                 "WI" = "48",
                 "WV" = "47",
                 "WY" = "49"))
  expect_equal(nibrs_parsed_sps$value_labels$B1009,
               c("Possessions" = "0",
                 "Cities 250,000+" = "1",
                 "Cities 1,000,000+" = "1A",
                 "Cities 500,000-999,999" = "1B",
                 "Cities 250,000-499,999" = "1C",
                 "Cities 100,000-249,999" = "2",
                 "Cities 50,000-99,999" = "3",
                 "Cities 25,000-49,999" = "4",
                 "Cities 10,000-24,999" = "5",
                 "Cities 2,500-9,999" = "6",
                 "Cites < 2,500" = "7",
                 "Non-MSA Counties" = "8",
                 "Non-MSA Counties 100,000+" = "8A",
                 "Non-MSA Counties 25,000-99,999" = "8B",
                 "Non-MSA Counties 10,000-24,999" = "8C",
                 "Non-MSA Counties < 10,000" = "8D",
                 "Non-MSA State Police" = "8E",
                 "MSA Counties" = "9",
                 "MSA Counties 100,000+" = "9A",
                 "MSA Counties 25,000-99,999" = "9B",
                 "MSA Counties 10,000-24,999" = "9C",
                 "MSA Counties < 10,000" = "9D",
                 "MSA State Police" = "9E"))
  expect_equal(nibrs_parsed_sps$value_labels$B1010,
               c("Possessions" = "0",
                 "New England" = "1",
                 "Middle Atlantic" = "2",
                 "East North Central" = "3",
                 "West North Central" = "4",
                 "South Atlantic" = "5",
                 "East South Central" = "6",
                 "West South Central" = "7",
                 "Mountain" = "8",
                 "Pacific" = "9"))
  expect_equal(nibrs_parsed_sps$value_labels$B1011,
               c("North East" = "1",
                 "North Central" = "2",
                 "South" = "3",
                 "West" = "4"))
  expect_equal(nibrs_parsed_sps$value_labels$B1012,
               c("Covered by another agency" = "0",
                 "City" = "1",
                 "County" = "2",
                 "University or college" = "3",
                 "State Police" = "4",
                 "Special Agency" = "5"))
  expect_equal(nibrs_parsed_sps$value_labels$B1013,
               c("Yes" = "Y",
                 "No" = "N"))
  expect_equal(nibrs_parsed_sps$value_labels$B1015,
               c("Blanked" = "9999"))
  expect_equal(nibrs_parsed_sps$value_labels$B1017,
               c("Inactive" = " ",
                 "Active" = "A"))

})

test_that("Sex offenders - parsed value labels are accurate", {
  expect_equal(sex_offender_parsed_sps$value_labels$MEETING,
               c("1" = "1",
                 "2" = "2",
                 "3" = "3",
                 "4" = "4",
                 "5" = "5",
                 "6" = "6",
                 "7" = "7",
                 "8" = "8",
                 "9" = "9",
                 "10" = "10",
                 "11" = "11",
                 "12" = "12",
                 "13" = "13",
                 "14" = "14",
                 "15" = "15",
                 "16" = "16",
                 "17" = "17",
                 "18" = "18",
                 "19" = "19",
                 "20" = "20",
                 "21" = "21",
                 "22" = "22"))
  expect_equal(sex_offender_parsed_sps$value_labels$DATE,
               c("Blanked" = "8888888"))
  expect_equal(sex_offender_parsed_sps$value_labels$Q1,
               c("Media" = "1",
                 "Flyers" = "2",
                 "Local official" = "3",
                 "Friend, etc." = "4",
                 "Other" = "5",
                 "Not sure" = "6",
                 "Multiple response" = "9",
                 "Blank" = "99"))
  expect_equal(sex_offender_parsed_sps$value_labels$Q2A,
               c("Checked" = "1",
                 "Blank" = "9"))
  expect_equal(sex_offender_parsed_sps$value_labels$Q3,
               c("Very clear" = "1",
                 "Moderate clear" = "2",
                 "Neutral" = "3",
                 "Somewhat clear" = "4",
                 "Very unclear" = "5",
                 "Not sure" = "6",
                 "Multiple response" = "9",
                 "Blank" = "99"))
  expect_equal(sex_offender_parsed_sps$value_labels$Q6E,
               c("Checked" = "1",
                 "Blank" = "9"))
  expect_equal(sex_offender_parsed_sps$value_labels$Q10,
               c("More anxious" = "1",
                 "Very anxious" = "2",
                 "Neutral" = "3",
                 "Somewhat less" = "4",
                 "Relieved" = "5",
                 "No opinion" = "6",
                 "Not sure" = "7",
                 "Multiple response" = "9",
                 "Blank" = "99"))
  expect_equal(sex_offender_parsed_sps$value_labels$INDEX,
               c("More concerned" = "1",
                 "Neutral" = "2",
                 "Less concerned" = "3",
                 "Blank" = "9"))
  expect_equal(sex_offender_parsed_sps$value_labels$NEWQ9G,
               c("Inadequate" = "1",
                 "Adequate +" = "2",
                 "Blank" = "9"))

})

test_that("Sac - parsed value labels are accurate", {
  expect_equal(sac_parsed_sps$value_labels$TODDATYR,
               c("Unknown" = "9999"))
  expect_equal(sac_parsed_sps$value_labels$CONSTATE,
               c("Maricopa, AZ" = "1",
                 "Sacramento, CA" = "2",
                 "Unknown" = "9"))
  expect_equal(sac_parsed_sps$value_labels$Q2JAGE,
               c("18-30 yrs" = "1",
                 "31-40 yrs" = "2",
                 "41-50 yrs" = "3",
                 "51-60 yrs" = "4",
                 "61-70 yrs" = "5",
                 "Over 70" = "6"))
  expect_equal(sac_parsed_sps$value_labels$Q3JETH,
               c("African American" = "1",
                 "Asian American" = "2",
                 "Caucasian" = "3",
                 "Hispanic/Latino" = "4",
                 "Other" = "5",
                 "Unknown" = "9"))
  expect_equal(sac_parsed_sps$value_labels$Q4JEDUC,
               c("H.S. or less / GED" = "1",
                 "College no degree" = "2",
                 "Associate degree" = "3",
                 "Bachelors" = "4",
                 "Graduate no degree" = "5",
                 "Graduate degree etc" = "6",
                 "Other" = "7"))
  expect_equal(length(sac_parsed_sps$value_labels$Q20TPEV3), 107)
  expect_equal(sac_parsed_sps$value_labels$KAGE,
               c("12 or younger at time of trial" = "1",
                 "13 or older at time of trial" = "2",
                 "Unknown" = "9"))
  expect_equal(sac_parsed_sps$value_labels$VERDICT,
               c("Not guilty" = "0",
                 "Guilty" = "1",
                 "Unknown" = "9"))
  expect_equal(sac_parsed_sps$value_labels$DURAT,
               c("Undoc code" = "-2",
                 "Unknown" = "99"))
  expect_equal(sac_parsed_sps$value_labels$DURAT2,
               c("2 years or less" = "1",
                 "3 years or more" = "2",
                 "Unknown" = "9"))

})

test_that("Parole - parsed value labels are accurate", {
  expect_equal(parole_parsed_sps$value_labels$STATEID,
               c("Federal" = "0",
                 "Alabama" = "1",
                 "Alaska" = "2",
                 "Arizona" = "4",
                 "Arkansas" = "5",
                 "California" = "6",
                 "Colorado" = "8",
                 "Connecticut" = "9",
                 "Delaware" = "10",
                 "District of Columbia" = "11",
                 "Florida" = "12",
                 "Georgia" = "13",
                 "Hawaii" = "15",
                 "Idaho" = "16",
                 "Illinois" = "17",
                 "Indiana" = "18",
                 "Iowa" = "19",
                 "Kansas" = "20",
                 "Kentucky" = "21",
                 "Louisiana" = "22",
                 "Maine" = "23",
                 "Maryland" = "24",
                 "Massachusetts" = "25",
                 "Michigan" = "26",
                 "Minnesota" = "27",
                 "Mississippi" = "28",
                 "Missouri" = "29",
                 "Montana" = "30",
                 "Nebraska" = "31",
                 "Nevada" = "32",
                 "New Hampshire" = "33",
                 "New Jersey" = "34",
                 "New Mexico" = "35",
                 "New York" = "36",
                 "North Carolina" = "37",
                 "North Dakota" = "38",
                 "Ohio" = "39",
                 "Oklahoma" = "40",
                 "Oregon" = "41",
                 "Pennsylvania" = "42",
                 "Rhode Island" = "44",
                 "South Carolina" = "45",
                 "South Dakota" = "46",
                 "Tennessee" = "47",
                 "Texas" = "48",
                 "Utah" = "49",
                 "Vermont" = "50",
                 "Virginia" = "51",
                 "Washington" = "53",
                 "West Virginia" = "54",
                 "Wisconsin" = "55",
                 "Wyoming" = "56"))
  expect_equal(parole_parsed_sps$value_labels$STATE,
               c("Alaska" = "AK",
                 "Alabama" = "AL",
                 "Arkansas" = "AR",
                 "Arizona" = "AZ",
                 "California" = "CA",
                 "Colorado" = "CO",
                 "Connecticut" = "CT",
                 "District of Columbia" = "DC",
                 "Delaware" = "DE",
                 "Federal" = "FE",
                 "Florida" = "FL",
                 "Georgia" = "GA",
                 "Hawaii" = "HI",
                 "Iowa" = "IA",
                 "Idaho" = "ID",
                 "Illinois" = "IL",
                 "Indiana" = "IN",
                 "Kansas" = "KS",
                 "Kentucky" = "KY",
                 "Louisiana" = "LA",
                 "Massachusetts" = "MA",
                 "Maryland" = "MD",
                 "Maine" = "ME",
                 "Michigan" = "MI",
                 "Minnesota" = "MN",
                 "Missouri" = "MO",
                 "Mississippi" = "MS",
                 "Montana" = "MT",
                 "North Carolina" = "NC",
                 "North Dakota" = "ND",
                 "Nebraska" = "NE",
                 "New Hampshire" = "NH",
                 "New Jersey" = "NJ",
                 "New Mexico" = "NM",
                 "Nevada" = "NV",
                 "New York" = "NY",
                 "Ohio" = "OH",
                 "Oklahoma" = "OK",
                 "Oregon" = "OR",
                 "Pennsylvania" = "PA",
                 "Rhode Island" = "RI",
                 "South Carolina" = "SC",
                 "South Dakota" = "SD",
                 "Tennessee" = "TN",
                 "Texas" = "TX",
                 "Utah" = "UT",
                 "Virginia" = "VA",
                 "Vermont" = "VT",
                 "Washington" = "WA",
                 "Wisconsin" = "WI",
                 "West Virginia" = "WV",
                 "Wyoming" = "WY"))
  expect_equal(parole_parsed_sps$value_labels$TOTBEG,
               c("Not known/Dont know" = "-9",
                 "Not applicable" = "-8"))
  expect_equal(parole_parsed_sps$value_labels$MALE,
               c("Not known/Dont know" = "-9",
                 "Not applicable" = "-8"))
  expect_equal(parole_parsed_sps$value_labels$ISP,
               c("No program" = "N",
                 "Yes" = "Y"))
  expect_equal(parole_parsed_sps$value_labels$ISPNUM,
               c("Not known/Dont know" = "-9",
                 "Not applicable" = "-8"))
  expect_equal(parole_parsed_sps$value_labels$ISPIN,
               c("Not known/Dont know" = "DK",
                 "No" = "N",
                 "Not applicable" = "NA",
                 "Yes" = "Y"))
  expect_equal(parole_parsed_sps$value_labels$EM,
               c("No program" = "N",
                 "Yes" = "Y"))
  expect_equal(parole_parsed_sps$value_labels$ENDOFYEAR,
               c("Not known/Dont know" = "DK",
                 "No" = "N",
                 "Yes" = "Y"))

})


test_that("Prisoners - parsed value labels are accurate", {
  expect_equal(prisoners_parsed_sps$value_labels$STATEID,
               c("01. Alabama" = "1",
                 "02. Alaska" = "2",
                 "04. Arizona" = "4",
                 "05. Arkansas" = "5",
                 "06. California" = "6",
                 "08. Colorado" = "8",
                 "09. Connecticut" = "9",
                 "10. Delaware" = "10",
                 "11. District of Columbia" = "11",
                 "12. Florida" = "12",
                 "13. Georgia" = "13",
                 "15. Hawaii" = "15",
                 "16. Idaho" = "16",
                 "17. Illinois" = "17",
                 "18. Indiana" = "18",
                 "19. Iowa" = "19",
                 "20. Kansas" = "20",
                 "21. Kentucky" = "21",
                 "22. Louisiana" = "22",
                 "23. Maine" = "23",
                 "24. Maryland" = "24",
                 "25. Massachusetts" = "25",
                 "26. Michigan" = "26",
                 "27. Minnesota" = "27",
                 "28. Mississippi" = "28",
                 "29. Missouri" = "29",
                 "30. Montana" = "30",
                 "31. Nebraska" = "31",
                 "32. Nevada" = "32",
                 "33. New Hampshire" = "33",
                 "34. New Jersey" = "34",
                 "35. New Mexico" = "35",
                 "36. New York" = "36",
                 "37. North Carolina" = "37",
                 "38. North Dakota" = "38",
                 "39. Ohio" = "39",
                 "40. Oklahoma" = "40",
                 "41. Oregon" = "41",
                 "42. Pennsylvania" = "42",
                 "44. Rhode Island" = "44",
                 "45. South Carolina" = "45",
                 "46. South Dakota" = "46",
                 "47. Tennessee" = "47",
                 "48. Texas" = "48",
                 "49. Utah" = "49",
                 "50. Vermont" = "50",
                 "51. Virginia" = "51",
                 "52. Jurisdiction shared between States" = "52",
                 "53. Washington" = "53",
                 "54. West Virginia" = "54",
                 "55. Wisconsin" = "55",
                 "56. Wyoming" = "56",
                 "State prison total" = "60",
                 "US prison total (state+federal)" = "70",
                 "Federal BOP" = "99"))
  expect_equal(prisoners_parsed_sps$value_labels$REGION,
               c("Northeast" = "1",
                 "Midwest" = "2",
                 "South" = "3",
                 "West" = "4",
                 "U.S. total" = "5",
                 "Federal Bureau of Prisons" = "6",
                 "State total" = "7"))
  expect_equal(prisoners_parsed_sps$value_labels$CWPRIVM,
               c("Data are missing because the state did not respond to the item" = "-9",
                 "Data are missing because the item was not applicable to the state" = "-8",
                 "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                 "Item not asked in survey for this year" = "-1"))
  expect_equal(prisoners_parsed_sps$value_labels$PVOTHF,
               c("Data are missing because the state did not respond to the item" = "-9",
                 "Data are missing because the item was not applicable to the state" = "-8",
                 "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                 "Item not asked in survey for this year" = "-1"))
  expect_equal(prisoners_parsed_sps$value_labels$PVINCLF,
               c("Data are missing because the state did not respond to the item" = "-9",
                 "Data are missing because the item was not applicable to the state" = "-8",
                 "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                 "Item not asked in survey for this year" = "-1",
                 "Yes" = "1",
                 "No" = "2"))
  expect_equal(prisoners_parsed_sps$value_labels$HANDLEF,
               c("Data are missing because the state did not respond to the item" = "-9",
                 "Data are missing because the item was not applicable to the state" = "-8",
                 "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                 "Item not asked in survey for this year" = "-1"))

})


test_that("CA vital - parsed value labels are accurate", {
  expect_equal(ca_vital_parsed_sps$value_labels$VICSEX,
               c("Unknown" = "0",
                 "Male" = "1",
                 "Female" = "2"))
  expect_equal(ca_vital_parsed_sps$value_labels$CRIMEST,
               c("Actual" = "1",
                 "Justifiable - private citizen" = "2",
                 "Manslaughter" = "3",
                 "Justifiable - peace officer" = "4"))
  expect_equal(length(ca_vital_parsed_sps$value_labels$PRECIP2), 46)
  expect_equal(ca_vital_parsed_sps$value_labels$SUS2RACE,
               c("Unknown" = "0",
                 "White (not Hispanic)" = "1",
                 "Hispanic" = "2",
                 "Black" = "3",
                 "American Indian" = "4",
                 "Chinese" = "5",
                 "Japanese" = "6",
                 "Filipino" = "7",
                 "Other" = "8",
                 "Pacific Islander" = "9",
                 "Other Asian" = "A",
                 "Black" = "B",
                 "Chinese" = "C",
                 "Cambodian" = "D",
                 "Filipino" = "F",
                 "Guamanian" = "G",
                 "Hispanic" = "H",
                 "American Indian" = "I",
                 "Japanese" = "J",
                 "Korean" = "K",
                 "Laotian" = "L",
                 "Other" = "O",
                 "Pacific Islander" = "P",
                 "Samoan" = "S",
                 "Hawaiian" = "U",
                 "Vietnamese" = "V",
                 "White" = "W",
                 "Unknown" = "X",
                 "Asian" = "Z"))
  expect_equal(ca_vital_parsed_sps$value_labels$EDUCATN,
               c("1 year of college" = "13",
                 "2 years of college" = "14",
                 "3 years of college" = "15",
                 "4 years of college" = "16",
                 "5+ years of college" = "17",
                 "Unknown or not available" = "99"))
  expect_equal(ca_vital_parsed_sps$value_labels$FLAG,
               c("No estimate (incident day as reported)" = "0",
                 "Estimate (incident day set to 01)" = "1"))
  expect_equal(ca_vital_parsed_sps$value_labels$HISPANIC,
               c("Not Spanish/Hispanic" = "1",
                 "Mexican/Mexican-American/Chicano" = "2",
                 "Puerto Rican" = "3",
                 "Cuban" = "4",
                 "Central/So. American" = "5",
                 "(Born outside U.S.),other Spanish/Hispan" = "6",
                 "Code not used" = "7",
                 "(Born in the U.S.), other Spanish/Hispan" = "8",
                 "Unknown or unreported" = "9"))
  expect_equal(ca_vital_parsed_sps$value_labels$MATCH,
               c("Death record did not match with homicide" = "0",
                 "Death record matched with homicide recor" = "1"))
})


test_that("LEOKA 1980 - parsed value labels are accurate", {

  expect_equal(leoka1980_parsed_sps$value_labels$V7,
               c("ALL CITIE 250K+"  = "1",
                 "CIT BET 100-249K" = "2",
                 "CIT BET 50-99.9K" = "3",
                 "CIT BET 25-49.9K" = "4",
                 "CIT BET 10-24.9K" = "5",
                 "CIT BET 2.5-9.9K" = "6",
                 "CITIE UNDER 2.5K" = "7",
                 "NON-SMSA COUNTIE" = "8",
                 "SMSA COUNTIES"    = "9"))
  expect_equal(leoka1980_parsed_sps$value_labels$V8,
               c("POSSESS GUAM ETC"      = "0",
                 "ALL CITIES 1M+"        = "11",
                 "CIT BET 500-999K"      = "12",
                 "CIT BET 250-499K"      = "13",
                 "CIT BET 100-249K"      = "20",
                 "CIT BET 50-99.9K"      = "30",
                 "CIT BET 25-49.9K"      = "40",
                 "CIT BET 10-24.9K"      = "50",
                 "CIT BET 2.5-9.9K"      = "60",
                 "CITIE UNDER 2.5K"      = "70",
                 "NON-SMSA 100K+"        = "81",
                 "NON-SMSA 25-99K"       = "82",
                 "NON-SMSA 10-24K"       = "83",
                 "NON-SMSA <10K"         = "84",
                 "NON-SMSA STATE POLICE" = "85",
                 "SMSA COUNT 10K+"       = "91",
                 "SMSA 25-99.9K"         = "92",
                 "SMSA 100K+"            = "93",
                 "SMSA COUNT <10K"       = "94",
                 "SMSA STATE POLICE"     = "95"))
  expect_equal(leoka1980_parsed_sps$value_labels$V11,
               c("GROUPS 8 AND 9" = "0"))
  expect_equal(leoka1980_parsed_sps$value_labels$V55,
               c("FOR ALL REPORTS" = "0",
                 "CITY LIST ASSAUL" = "1",
                 "CITY LIST ONLY" = "2"))
  expect_equal(leoka1980_parsed_sps$value_labels$V56,
               c("POL EMPLOY DA" = "0",
                 "NOT UPDATED,NONE" = "1",
                 "CONTAINS POL DA" = "2"))
  expect_equal(leoka1980_parsed_sps$value_labels$V72,
               c("NORMAL" = "0",
                 "NO BREAKDOWNS. A" = "1"))
  expect_equal(leoka1980_parsed_sps$value_labels$V73,
               c("INFORMAT COMPLET" = "0",
                 "ASSAULTS NOT REP" = "1",
                 "ASSAULTS REPORTE" = "2"))
  expect_equal(leoka1980_parsed_sps$value_labels$V96,
               c("INFORMAT COMPLET" = "0",
                 "ASSAULTS NOT REP" = "1",
                 "ASSAULTS REPORTE" = "2"))

})


test_that("Property stolen - parsed value labels are accurate", {

  expect_equal(property_stolen_parsed_sps$value_labels$V2,
               c("Alabama" = "1",
                 "Arizona" = "2",
                 "Arkansas" = "3",
                 "California" = "4",
                 "Colorado" = "5",
                 "Connecticut" = "6",
                 "Delaware" = "7",
                 "District of Columbia" = "8",
                 "Florida" = "9",
                 "Georgia" = "10",
                 "Idaho" = "11",
                 "Illinois" = "12",
                 "Indiana" = "13",
                 "Iowa" = "14",
                 "Kansas" = "15",
                 "Kentucky" = "16",
                 "Louisiana" = "17",
                 "Maine" = "18",
                 "Maryland" = "19",
                 "Massachusetts" = "20",
                 "Michigan" = "21",
                 "Minnesota" = "22",
                 "Mississippi" = "23",
                 "Missouri" = "24",
                 "Montana" = "25",
                 "Nebraska" = "26",
                 "Nevada" = "27",
                 "New Hampshire" = "28",
                 "New Jersey" = "29",
                 "New Mexico" = "30",
                 "New York" = "31",
                 "North Carolina" = "32",
                 "North Dakota" = "33",
                 "Ohio" = "34",
                 "Oklahoma" = "35",
                 "Oregon" = "36",
                 "Pennsylvania" = "37",
                 "Rhode Island" = "38",
                 "South Carolina" = "39",
                 "South Dakota" = "40",
                 "Tennessee" = "41",
                 "Texas" = "42",
                 "Utah" = "43",
                 "Vermont" = "44",
                 "Virginia" = "45",
                 "Washington" = "46",
                 "West Virginia" = "47",
                 "Wisconsin" = "48",
                 "Wyoming" = "49",
                 "Alaska" = "50",
                 "Hawaii" = "51",
                 "Canal Zone" = "52",
                 "Puerto Rico" = "53",
                 "American Samoa" = "54",
                 "Guam" = "55",
                 "Virgin Islands" = "62"))
  expect_equal(property_stolen_parsed_sps$value_labels$V4,
               c("Possessions as Puerto Rico, Guam" = "0",
                 "All cities 250,000 +" = "1",
                 "Cit 1,000,000 +" = "1A",
                 "Cit 500,000-999,999" = "1B",
                 "Cit 250,000-499,999" = "1C",
                 "Cit 100,000-249,999" = "2",
                 "Cit 50,000-99,999" = "3",
                 "Cit 25,000-49,999" = "4",
                 "Cit 10,000-24,999" = "5",
                 "Cit 2,500-9,999" = "6",
                 "Cit < 2,500" = "7",
                 "Non-MSA counties" = "8",
                 "Non-MSA co. 100,000 +" = "8A",
                 "Non-MSA co. 25,000-99,999" = "8B",
                 "Non-MSA co. 10,000-24,999" = "8C",
                 "Non-MSA co. < 10,000" = "8D",
                 "Non-MSA state police" = "8E",
                 "MSA counties" = "9",
                 "MSA co. 100,000 +" = "9A",
                 "MSA co. 25,000-99,999" = "9B",
                 "MSA co. 10,000-24,999" = "9C",
                 "MSA co. < 10,000" = "9D",
                 "MSA state police" = "9E"))
  expect_equal(property_stolen_parsed_sps$value_labels$V5,
               c("Possessions" = "0",
                 "New England" = "1",
                 "Middle Atlantic" = "2",
                 "East North Central" = "3",
                 "West North Central" = "4",
                 "South Atlantic" = "5",
                 "East South Central" = "6",
                 "West South Central" = "7",
                 "Mountain" = "8",
                 "Pacific" = "9"))
  expect_equal(property_stolen_parsed_sps$value_labels$V11,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V104,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V197,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V290,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V383,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V476,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V569,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V662,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V755,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V848,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V941,
               c("Not reported" = "0",
                 "Regular"      = "1"))
  expect_equal(property_stolen_parsed_sps$value_labels$V1034,
               c("Not reported" = "0",
                 "Regular"      = "1"))

})

test_that("NCVS - parsed value labels are accurate", {


  expect_equal(ncvs_parsed_sps$value_labels$V2009,
               c("Residue" = "9998",
                 "Out of universe" = "9999"))
  expect_equal(ncvs_parsed_sps$value_labels$V2016,
               c("Urban" = "1",
                 "Rural - 10 acres or more" = "2",
                 "Rural - less than 10 acres" = "3",
                 "Residue" = "8",
                 "Out of universe" = "9"))

  expect_equal(ncvs_parsed_sps$value_labels$V4116,
               c("No" = "0",
                 "Yes" = "1",
                 "Not applicable" = "8",
                 "Out of universe" = "9"))
  expect_equal(ncvs_parsed_sps$value_labels$V4117,
               c("No" = "0",
                 "Yes" = "1",
                 "Not applicable" = "8",
                 "Out of universe" = "9"))
  expect_equal(ncvs_parsed_sps$value_labels$V4118,
               c("No" = "0",
                 "Yes" = "1",
                 "Not applicable" = "8",
                 "Out of universe" = "9"))
  expect_equal(ncvs_parsed_sps$value_labels$V4119,
               c("No" = "0",
                 "Yes" = "1",
                 "Not applicable" = "8",
                 "Out of universe" = "9"))
  expect_equal(ncvs_parsed_sps$value_labels$V4121,
               c("Yes" = "1",
                 "No" = "2",
                 "Don t know" = "3",
                 "Residue" = "8",
                 "Out of universe" = "9"))
  expect_equal(ncvs_parsed_sps$value_labels$V4122,
               c("Yes" = "1",
                 "Part" = "2",
                 "Not yet settled" = "3",
                 "None" = "4",
                 "Residue" = "8",
                 "Out of universe" = "9"))
  expect_equal(ncvs_parsed_sps$value_labels$V4322,
               c("Score obtained by adding elements" = "9999.00"))
  expect_equal(ncvs_parsed_sps$value_labels$V4323,
               c("Score obtained by adding elements" = "99"))
  expect_equal(ncvs_parsed_sps$value_labels$V4327,
               c("Stranger" = "1",
                 "Nonstranger" = "2",
                 "Out of universe" = "9"))

})


test_that("Jail survey 1987 - parsed value labels are accurate", {


  expect_equal(jail_1987_parsed_sps$value_labels$V1,
               c("ICPSR NUMBER" = "9074"))
  expect_equal(jail_1987_parsed_sps$value_labels$V2,
               c("SPRING,1989" = "1"))
  expect_equal(jail_1987_parsed_sps$value_labels$V6,
               c("ALABAMA" = "1",
                 "ALASKA" = "2",
                 "ARIZONA" = "3",
                 "ARKANSAS" = "4",
                 "CALIFORNIA" = "5",
                 "COLORADO" = "6",
                 "CONNECTICUT" = "7",
                 "DELAWARE" = "8",
                 "DIST OF COLUMBIA" = "9",
                 "FLORIDA" = "10",
                 "GEORGIA" = "11",
                 "HAWAII" = "12",
                 "IDAHO" = "13",
                 "ILLINOIS" = "14",
                 "INDIANA" = "15",
                 "IOWA" = "16",
                 "KANSAS" = "17",
                 "KENTUCKY" = "18",
                 "LOUISIANA" = "19",
                 "MAINE" = "20",
                 "MARYLAND" = "21",
                 "MASSACHUSETTS" = "22",
                 "MICHIGAN" = "23",
                 "MINNESOTA" = "24",
                 "MISSISSIPPI" = "25",
                 "MISSOURI" = "26",
                 "MONTANA" = "27",
                 "NORTH CAROLINA" = "28",
                 "NORTH DAKOTA" = "29",
                 "NEBRASKA" = "30",
                 "NEVADA" = "31",
                 "NEW HAMPSHIRE" = "32",
                 "NEW JERSEY" = "33",
                 "NEW MEXICO" = "34",
                 "NEW YORK" = "35",
                 "OHIO" = "36",
                 "OKLAHOMA" = "37",
                 "OREGON" = "38",
                 "PENNSYLVANIA" = "39",
                 "RHODE ISLAND" = "40",
                 "SOUTH CAROLINA" = "41",
                 "SOUTH DAKOTA" = "42",
                 "TENNESSEE" = "43",
                 "TEXAS" = "44",
                 "UTAH" = "45",
                 "VIRGINIA" = "46",
                 "VERMONT" = "47",
                 "WASHINGTON" = "48",
                 "WISCONSIN" = "49",
                 "WEST VIRGINIA" = "50",
                 "WYOMING" = "51"))
  expect_equal(jail_1987_parsed_sps$value_labels$V7,
               c("COUNTY LEVEL" = "1",
                 "CITY LEVEL" = "2"))
  expect_equal(jail_1987_parsed_sps$value_labels$V13,
               c("CERTAINTY UNIT" = "1",
                 "SAMPLE UNIT" = "2",
                 "SAMPLE UNIT" = "3",
                 "SAMPLE UNIT" = "4"))
  expect_equal(jail_1987_parsed_sps$value_labels$V156,
               c("YES" = "1",
                 "NO" = "2"))
  expect_equal(jail_1987_parsed_sps$value_labels$V162,
               c("YES" = "1",
                 "NO" = "2"))
  expect_equal(jail_1987_parsed_sps$value_labels$V163, c("YES" = "1"))
  expect_equal(jail_1987_parsed_sps$value_labels$V164, c("YES" = "2"))
  expect_equal(jail_1987_parsed_sps$value_labels$V165, c("YES" = "3"))
  expect_equal(jail_1987_parsed_sps$value_labels$V166, c("YES" = "4"))
  expect_equal(jail_1987_parsed_sps$value_labels$V167, c("YES" = "5"))
  expect_equal(jail_1987_parsed_sps$value_labels$V168, c("YES" = "6"))
  expect_equal(jail_1987_parsed_sps$value_labels$V169, c("YES" = "7"))
  expect_equal(jail_1987_parsed_sps$value_labels$V170, c("YES" = "8"))
  expect_equal(jail_1987_parsed_sps$value_labels$V171, c("YES" = "9"))
  expect_equal(jail_1987_parsed_sps$value_labels$V172, c("YES" = "10"))
  expect_equal(jail_1987_parsed_sps$value_labels$V173, c("YES" = "11"))
  expect_equal(jail_1987_parsed_sps$value_labels$V174, c("YES" = "12"))
  expect_equal(jail_1987_parsed_sps$value_labels$V175, c("YES" = "13"))
  expect_equal(jail_1987_parsed_sps$value_labels$V176, c("CENSUS CODE" = "0"))



})

test_that("Corrections - parsed value labels are accurate", {


  expect_equal(corrections_parsed_sps$value_labels$SEX,
               c("Male" = "1",
                 "Female" = "2"))
  expect_equal(corrections_parsed_sps$value_labels$EDUCATION,
               c("<HS diploma/GED" = "1",
                 "HS diploma/GED" = "2",
                 "Any college" = "3",
                 "Ungraded/unknown" = "9"))
  expect_equal(corrections_parsed_sps$value_labels$ADMTYPE,
               c("New court commitment" = "1",
                 "Parole return/revocation" = "2",
                 "Other admission (including unsentenced, transfer, AWOL/escapee return)" = "3",
                 "Missing" = "9"))
  expect_equal(corrections_parsed_sps$value_labels$OFFGENERAL,
               c("Violent" = "1",
                 "Property" = "2",
                 "Drugs" = "3",
                 "Public order" = "4",
                 "Other/unspecified" = "5",
                 "Missing" = "9"))
  expect_equal(corrections_parsed_sps$value_labels$SENTLGTH,
               c("< 1 year" = "0",
                 "1-1.9 years" = "1",
                 "2-4.9 years" = "2",
                 "5-9.9 years" = "3",
                 "10-24.9 years" = "4",
                 ">=25 years" = "5",
                 "Life, LWOP, Life plus additional years, Death" = "6",
                 "Missing" = "9"))
  expect_equal(corrections_parsed_sps$value_labels$OFFDETAIL,
               c("Murder (including non-negligent manslaughter)" = "1",
                 "Negligent manslaughter" = "2",
                 "Rape/sexual assault" = "3",
                 "Robbery" = "4",
                 "Aggravated or simple assault" = "5",
                 "Other violent offenses" = "6",
                 "Burglary" = "7",
                 "Larceny" = "8",
                 "Motor vehicle theft" = "9",
                 "Fraud" = "10",
                 "Other property offenses" = "11",
                 "Drugs (includes possession, distribution, trafficking, other)" = "12",
                 "Public order" = "13",
                 "Other/unspecified" = "14",
                 "Missing" = "99"))
  expect_equal(corrections_parsed_sps$value_labels$RACE,
               c("White, non-Hispanic" = "1",
                 "Black, non-Hispanic" = "2",
                 "Hispanic, any race" = "3",
                 "Other race(s), non-Hispanic" = "4",
                 "Missing" = "9"))
  expect_equal(corrections_parsed_sps$value_labels$AGEADMIT,
               c("18-24 years" = "1",
                 "25-34 years" = "2",
                 "35-44 years" = "3",
                 "45-54 years" = "4",
                 "55+ years" = "5",
                 "Missing" = "9"))

})


test_that("Jail survey 2010 - parsed value labels are accurate", {


  expect_equal(jail_2010_parsed_sps$value_labels$CONFPOPF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$NCONPOPF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$PRETRIALF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$TREATMENTF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$NONCONFDF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$ADFMNCNFF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$JVFMNCNFF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$CONVNCNFF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$UNCNVNCFF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$UNCNVNCFF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$ASIANF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$BLACKF,
               c("Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$OTHERMAJVIO,
               c("Blank" = "-9"))
  expect_equal(jail_2010_parsed_sps$value_labels$ESCAPE,
               c("Blank" = "-9"))
  expect_equal(jail_2010_parsed_sps$value_labels$STOLENPROPF,
               c("Blank" = "-9",
                 "Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$ESCAPEF,
               c("Blank" = "-9",
                 "Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))
  expect_equal(jail_2010_parsed_sps$value_labels$OTHERMAJVIOF,
               c("Blank" = "-9",
                 "Actual" = "0",
                 "Estimated" = "1",
                 "Not applicable" = "8",
                 "Dont know" = "9"))

})


test_that("SADC - parsed value labels are accurate", {


  expect_equal(sadc_parsed_sps$value_labels$Q8,
               c("Never"            = "1",
                 "Rarely"           = "2",
                 "Sometimes"        = "3",
                 "Most of the time" = "4",
                 "Always"           = "5"))
  expect_equal(sadc_parsed_sps$value_labels$Q9,
               c("0 times"         = "1",
                 "1 time"          = "2",
                 "2 or 3 times"    = "3",
                 "4 or 5 times"    = "4",
                 "6 or more times" = "5"))
  expect_equal(sadc_parsed_sps$value_labels$Q10,
               c("Did not drive"   = "1",
                 "0 times"         = "2",
                 "1 time"          = "3",
                 "2 or 3 times"    = "4",
                 "4 or 5 times"    = "5",
                 "6 or more times" = "6"))
  expect_equal(sadc_parsed_sps$value_labels$Q11,
               c("Did not drive" = "1",
                 "0 days"        = "2",
                 "1 or 2 days"   = "3",
                 "3 to 5 days"   = "4",
                 "6 to 9 days"   = "5",
                 "10 to 19 days" = "6",
                 "20 to 29 days" = "7",
                 "All 30 days"   = "8"))
  expect_equal(sadc_parsed_sps$value_labels$Q12,
               c("0 days"         = "1",
                 "1 day"          = "2",
                 "2 or 3 days"    = "3",
                 "4 or 5 days"    = "4",
                 "6 or more days" = "5"))
  expect_equal(sadc_parsed_sps$value_labels$Q13,
               c("0 days"         = "1",
                 "1 day"          = "2",
                 "2 or 3 days"    = "3",
                 "4 or 5 days"    = "4",
                 "6 or more days" = "5"))
  expect_equal(sadc_parsed_sps$value_labels$Q14,
               c("0 days"         = "1",
                 "1 day"          = "2",
                 "2 or 3 days"    = "3",
                 "4 or 5 days"    = "4",
                 "6 or more days" = "5"))
  expect_equal(sadc_parsed_sps$value_labels$Q15,
               c("0 days"         = "1",
                 "1 day"          = "2",
                 "2 or 3 days"    = "3",
                 "4 or 5 days"    = "4",
                 "6 or more days" = "5"))
  expect_equal(sadc_parsed_sps$value_labels$Q16,
               c("0 times"          = "1",
                 "1 time"           = "2",
                 "2 or 3 times"     = "3",
                 "4 or 5 times"     = "4",
                 "6 or 7 times"     = "5",
                 "8 or 9 times"     = "6",
                 "10 or 11 times"   = "7",
                 "12 or more times" = "8"))
  expect_equal(sadc_parsed_sps$value_labels$Q58,
               c("Yes" = "1",
                 "No"  = "2"))
  expect_equal(sadc_parsed_sps$value_labels$Q77,
               c("Did not drink milk"        = "1",
                 "1 to 3 glasses"            = "2",
                 "4 to 6 glasses"            = "3",
                 "1 glass per day"           = "4",
                 "2 glasses per day"         = "5",
                 "3 glasses per day"         = "6",
                 "4 or more glasses per day" = "7"))
  expect_equal(sadc_parsed_sps$value_labels$qchewtobschool,
               c("0 days"        = "1",
                 "1 or 2 days"   = "2",
                 "3 to 5 days"   = "3",
                 "6 to 9 days"   = "4",
                 "10 to 19 days" = "5",
                 "20 to 29 days" = "6",
                 "All 30 days"   = "7"))
  expect_equal(sadc_parsed_sps$value_labels$age,
               c("12 years old or younger" = "1",
                 "13 years old"            = "2",
                 "14 years old"            = "3",
                 "15 years old"            = "4",
                 "16 years old"            = "5",
                 "17 years old"            = "6",
                 "18 years old or older"   = "7"))
  expect_equal(sadc_parsed_sps$value_labels$race7,
               c("Am Indian / Alaska Native" = "1",
                 "Asian"                     = "2",
                 "Black or African American" = "3",
                 "Hispanic/Latino"           = "4",
                 "Native Hawaiian/other PI"  = "5",
                 "White"                     = "6",
                 "Multiple - Non-Hispanic"   = "7"))
  expect_equal(sadc_parsed_sps$value_labels$sexid2,
               c("Heterosexual"    = "1",
                 "Sexual Minority" = "2",
                 "Unsure"          = "3"))
  expect_equal(sadc_parsed_sps$value_labels$sexpart,
               c("Never had sex"     = "1",
                 "Opposite sex only" = "2",
                 "Same sex only"     = "3",
                 "Both Sexes"        = "4"))
  expect_equal(sadc_parsed_sps$value_labels$sexpart2,
               c("Never had sex"               = "1",
                 "Opposite sex only"           = "2",
                 "Same sex only or both sexes" = "3"))

})




test_that("Crosswalk 2012 - parsed value labels are accurate", {


  expect_equal(crosswalk2012_parsed_sps$value_labels$ORI9,
               c("Not in UCR/NCIC"    = "-1"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$UA,
               c("Not a Census place" = "-1"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$SUBTYPE1,
               c("Public buildings/facilities"            = "1",
                 "Natural resources/parks and recreation" = "2",
                 "Transportation systems/facilities"      = "3",
                 "Criminal investigations"                = "4",
                 "Special enforcement"                    = "5",
                 "Not applicable"                         = "888"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$GOVID,
               c("Multi-jurisdiction (see COMMENTS)" = "999999991",
                 "Undetermined"                      = "999999999"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$INTPTLAT,
               c("Undetermined" = "-9"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$INTPTLONG,
               c("Undetermined" = "-9"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$CONGDIST1,
               c("Undetermined" = "-9"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$FCOUNTY,
               c("Multi-jurisdiction (see COMMENTS)" = "991",
                 "Federal agency"                    = "997",
                 "Undetermined"                      = "999"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$AGCYTYPE,
               c("Local police department"      = "0",
                 "Sheriffs office"              = "1",
                 "State law enforcement agency" = "5",
                 "Special jurisdiction"         = "6",
                 "Constable/Marshal"            = "7",
                 "Federal"                      = "997"))
  expect_equal(crosswalk2012_parsed_sps$value_labels$REPORT_FLAG,
               c("Record has no ORI"                         = "0",
                 "ORI reported 1+ offenses"                  = "1",
                 "ORI reported 0 offenses or did not report" = "2"))

})


test_that("Dutch election - parsed value labels are accurate", {


  expect_equal(dutch_election_parsed_sps$value_labels$V3,
               c("GRONINGEN"    = "01",
                 "FRIESLAND"    = "02",
                 "DRENTE"    = "03",
                 "OVERIJSSEL"    = "04",
                 "GELDERLAND"    = "05",
                 "UTRECHT"    = "06",
                 "NOORD-HOLLAND"    = "07",
                 "ZUID-HOLLAND"    = "08",
                 "ZEELAND"    = "09",
                 "NOORD-BRABANT"    = "10",
                 "LIMBURG"    = "11"))

  expect_equal(dutch_election_parsed_sps$value_labels$V123A,
               c("INAP"    = "97"))

  expect_equal(dutch_election_parsed_sps$value_labels$V123B,
               c("INAP"    = "97"))

  expect_equal(dutch_election_parsed_sps$value_labels$V132,
               c("VERY SATISFIED"    = "1",
                 "SOMEWHAT SATISFIED"    = "3",
                 "NOT SATISFIED"    = "5",
                 "DK"    = "8",
                 "NA"    = "9"))

  expect_equal(dutch_election_parsed_sps$value_labels$V231,
               c("MEMBER OF ASSOCIATION OR ORGANIZATION ORIENTED"    = "0",
                 "OTHER POLITICAL ORGANIZATION"    = "1",
                 "NOT A MEMBER OF A POLITICAL ORGANIZATION"    = "5",
                 "DK"    = "8",
                 "NA"    = "9"))

  expect_equal(dutch_election_parsed_sps$value_labels$V236,
               c("01 - 24"    = "0",
                 "25 - 49"    = "1",
                 "50 - 74"    = "2",
                 "75 (CORRECT NUMBER)"    = "3",
                 "76 - 100"    = "4",
                 "101 - 125"    = "5",
                 "126 - 150"    = "6",
                 "151 OR MORE"    = "7",
                 "DK"    = "8",
                 "NA"    = "9"))

  expect_equal(dutch_election_parsed_sps$value_labels$V421,
               c("DIFFERENCES SHOULD REMAIN AS THEY ARE"    = "1",
                 "DIFFERENCES SHOULD BECOME LESS"    = "7",
                 "DK"    = "8",
                 "NA"    = "9",
                 "INAP"    = "0"))

  expect_equal(dutch_election_parsed_sps$value_labels$V422,
               c("DIFFERENCES SHOULD REMAIN AS THEY ARE"    = "1",
                 "DIFFERENCES SHOULD BECOME LESS"    = "7",
                 "DK"    = "8",
                 "NA"    = "9",
                 "INAP"    = "0"))

  expect_equal(dutch_election_parsed_sps$value_labels$V472A,
               c("INAP"    = "97",
                 "DK"    = "98",
                 "NA; INAP"    = "99"))

  expect_equal(dutch_election_parsed_sps$value_labels$V587,
               c("MEMBERS ALLOW THEMSELVES TO BE MINIMALLY INFLUENCED"    = "1",
                 "MEMBERS ALLOW THEMSELVES TO BE STRONGLY INFLUENCED"    = "7",
                 "DK"    = "8",
                 "NA"    = "9",
                 "INAP"    = "0"))

  expect_equal(dutch_election_parsed_sps$value_labels$V588,
               c("DK"    = "98",
                 "NA; INAP"    = "99"))

  expect_equal(dutch_election_parsed_sps$value_labels$V626,
               c("Q"    = "01",
                 "Q"    = "02",
                 "Q"    = "03",
                 "Q"    = "04",
                 "Q"    = "05",
                 "Q"    = "06",
                 "Q"    = "07",
                 "Q"    = "08",
                 "Q"    = "09",
                 "Q"    = "10",
                 "Q"    = "11",
                 "Q"    = "12",
                 "Q"    = "13",
                 "Q"    = "14",
                 "Q"    = "15",
                 "Q"    = "16",
                 "Q"    = "17",
                 "Q"    = "18",
                 "Q"    = "19",
                 "Q"    = "20",
                 "Q"    = "21",
                 "Q"    = "22",
                 "Q"    = "23",
                 "Q"    = "24",
                 "Q"    = "25",
                 "SOME QUESTIONS"    = "87",
                 "THE MAJORITY"    = "88",
                 "NO QUESTION UNRELIABLE"    = "89",
                 "DK"    = "98",
                 "NA"    = "99",
                 "INAP"    = "00"))

  expect_equal(dutch_election_parsed_sps$value_labels$V627,
               c("VERY HIGH"    = "1",
                 "FAIRLY HIGH"    = "2",
                 "AVERAGE"    = "3",
                 "FAIRLY LOW"    = "4",
                 "VERY LOW"    = "5",
                 "NA"    = "9",
                 "INAP"    = "0"))

  expect_equal(dutch_election_parsed_sps$value_labels$V765,
               c("VERY HIGH"    = "1",
                 "FAIRLY HIGH"    = "2",
                 "AVERAGE"    = "3",
                 "FAIRLY LOW"    = "4",
                 "VERY LOW"    = "5",
                 "NA"    = "9",
                 "INAP"    = "0"))
  expect_equal(dutch_election_parsed_sps$value_labels$V766,
               c("RESPONSE 1970, RESPONSE 1971, RESPONSE 1972"    = "1",
                 "RESPONSE 1970, RESPONSE 1971, NON-RESPONSE 1972"    = "2",
                 "RESPONSE 1970, RESPONSE 1971, MAILED QUESTIONNAIRE"    = "3",
                 "RESPONSE 1970, NON-RESPONSE 1971, RESPONSE 1972"    = "4",
                 "RESPONSE 1970, NON-RESPONSE 1971, NON-RESPONSE 1972"    = "5",
                 "RESPONSE 1970, NON-RESPONSE 1971, MAILED QUESTION-"    = "6"))

})
