*-------------------------------------------------------------------------*
 |                                                                        |
 |              SPSS DATA DEFINITION STATEMENTS FOR ICPSR 3425            |
 |                 MONITORING THE FUTURE (12th GRADE), 2001               |
 |                           (PART 1: CORE DATA)                          |
 |                             1ST ICPSR EDITION                          |
 |                             NOVEMBER, 2002                             |
 |                                                                        |
 |                                                                        |
 | SPSS setup sections are provided for the LRECL version of this data    |
 | collection.  These sections are listed below:                          |
 |                                                                        |
 | DATA LIST:  assigns the name, type, decimal specification (if any),    |
 | and specifies the beginning and ending column locations for each       |
 | variable in the data file. Users must replace the "data-filename"      |
 | in the DATA LIST statement with a filename specifying the directory    |
 | on the user's computer system in which the downloaded and unzipped     |
 | data file is physically located (e.g., "c:\temp\da6949.p1").           |
 |                                                                        |
 | VARIABLE LABELS:  assigns descriptive labels to all variables.         |
 | Labels and variable names may be identical for some data files.        |
 |                                                                        |
 | MISSING VALUES: declares user-defined missing values. Not all          |
 | variables in this data set necessarily have user-defined missing       |
 | values. These values can be treated specially in data transformations, |
 | statistical calculations, and case selection.                          |
 |                                                                        |
 | VALUE LABELS: assigns descriptive labels to codes found in the data    |
 | file.  Not all codes necessarily have assigned value labels.           |
 |                                                                        |
 | NOTE:  Users should modify these data definition statements to suit    |
 | their specific needs. The MISSING VALUES section has been commented    |
 | out (i.e., '*').  To include the MISSING VALUES section in the final   |
 | SPSS setup, remove the comment indicators from the desired section.    |
 |                                                                        |
 | These data definition statements have been tested for compatibility    |
 | with SPSS Release 6.14 for UNIX and SPSS Release 11.0 for Windows.     |
 |                                                                        |
 | CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save  |
 | an SPSS data file for further analysis using SPSS for Windows, the     |
 | necessary "SAVE OUTFILE" command is provided in the last line of       |
 | this file.  To activate the command, users must delete the leading     |
 | asterisk (*) and replace "spss-filename" with a filename specifying    |
 | the location on the user's computer system to which the new data file  |
 | will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\nhsda82.sav").      |
*-------------------------------------------------------------------------.
                                                                           
* SPSS FILE HANDLE, DATA LIST COMMANDS.                                    
                                                                           
FILE HANDLE DATA / NAME="data-filename" LRECL=224.                         
DATA LIST FILE=DATA /                                                      
     V13 1-1      V16 2-2      V17 3-3                                     
     V5 4-9 (4)      V1 10-13      V3 14-14                                
     V4 15-19      V130 20-21      V131 22-23                              
     V132 24-25      V49 26-27      V101 28-29                             
     V102 30-31      V103 32-33      V104 34-35                            
     V105 36-37      V106 38-39      V107 40-41                            
     V108 42-43      V115 44-45      V116 46-47                            
     V117 48-49      V118 50-51      V119 52-53                            
     V120 54-55      V121 56-57      V122 58-59                            
     V123 60-61      V124 62-63      V125 64-65                            
     V126 66-67      V127 68-69      V128 70-71                            
     V129 72-73      V133 74-75      V134 76-77                            
     V135 78-79      V136 80-81      V137 82-83                            
     V138 84-85      V139 86-87      V140 88-89                            
     V141 90-91      V142 92-93      V143 94-95                            
     V144 96-97      V145 98-99      V146 100-101                          
     V147 102-103      V148 104-105      V150 106-107                      
     V151 108-109      V152 110-111      V153 112-113                      
     V155 114-115      V156 116-117      V157 118-119                      
     V163 120-121      V164 122-123      V165 124-125                      
     V166 126-127      V167 128-129      V169 130-131                      
     V170 132-133      V171 134-135      V172 136-137                      
     V173 138-139      V174 140-141      V175 142-143                      
     V176 144-145      V177 146-147      V178 148-149                      
     V179 150-151      V180 152-153      V181 154-155                      
     V182 156-157      V183 158-159      V184 160-161                      
     V185 162-163      V186 164-165      V187 166-167                      
     V188 168-169      V189 170-171      V190 172-173                      
     V191 174-175      V192 176-177      V193 178-179                      
     V194 180-181      V195 182-183      V196 184-185                      
     V197 186-187      V198 188-189      V199 190-191                      
     V200 192-193      V201 194-195      V202 196-197                      
     V203 198-199      V204 200-201      V109 202-203                      
     V110 204-205      V111 206-207      V112 208-209                      
     V113 210-211      V114 212-213      V205 214-215                      
     V206 216-217      V207 218-219      CASEID 220-224.                   
                                                                           
* SPSS VARIABLE LABELS COMMAND.                                            
                                                                           
VARIABLE LABELS                                                            
   V13 '012     :SCHL RGN-4 CAT'                                           
   V16 '012     :SELF-REP/NOT=0'                                           
   V17 '012     :SMSA/NON-SMSA=0'                                          
   V5 'SAMPLING WEIGHT'                                                    
   V1 'YEAR OF ADMIN (4-DIGITS)'                                           
   V3 '012    :FORM ID'                                                    
   V4 "012    :R'S ID-SERIAL #"                                            
   V130 '012B12A:#X ICE/LIFETIME'                                          
   V131 '012B12B:#X ICE/LAST12MO'                                          
   V132 '012B12C:#X ICE/LAST30DA'                                          
   V49 '01C07R:# SIBLINGS'                                                 
   V101 '012B01 :EVR SMK CIG,REGL'                                         
   V102 '012B02 :#CIGS SMKD/30DAY'                                         
   V103 '012B03 :EVER DRINK'                                               
   V104 '012B04A:#X ALC/LIF SIPS'                                          
   V105 '012B04B:#X ALC/ANN SIPS'                                          
   V106 '012B04C:#X ALC/30D SIPS'                                          
   V107 '012B05 :#X DRK ENF FL HI'                                         
   V108 '012B06 :5+DRK ROW/LST 2W'                                         
   V115 '012B07A:#XMJ+HS/LIFETIME'                                         
   V116 '012B07B:#XMJ+HS/LAST12MO'                                         
   V117 '012B07C:#XMJ+HS/LAST30DA'                                         
   V118 '012B08A:#X LSD/LIFETIME'                                          
   V119 '012B08B:#X LSD/LAST 12MO'                                         
   V120 '012B08C:#X LSD/LAST 30DA'                                         
   V121 '012B09A:#X PSYD/LIFETIME'                                         
   V122 '012B09B:#X PSYD/LAST12MO'                                         
   V123 '012B09C:#X PSYD/LAST30DA'                                         
   V124 '012B10A:#X COKE/LIFETIME'                                         
   V125 '012B10B:#X COKE/LAST12MO'                                         
   V126 '012B10C:#X COKE/LAST30DA'                                         
   V127 '012B11A:#X AMPH/LIFETIME'                                         
   V128 '012B11B:#X AMPH/LAST12MO'                                         
   V129 '012B11C:#X AMPH/LAST30DA'                                         
   V133 '012B13A:#X BRBT/LIFETIME'                                         
   V134 '012B13B:#X BRBT/LAST12MO'                                         
   V135 '012B13C:#X BRBT/LAST30DA'                                         
   V136 '012B14A:#X TRQL/LIFETIME'                                         
   V137 '012B14B:#X TRQL/LAST12MO'                                         
   V138 '012B14C:#X TRQL/LAST30DA'                                         
   V139 '012R*  :#X "H"/LIFETIME'                                          
   V140 '012R*  :#X "H"/LAST12MO'                                          
   V141 '012R*  :#X "H"/LAST30DAY'                                         
   V142 '012B17A:#X NARC/LIFETIME'                                         
   V143 '012B17B:#X NARC/LAST12MO'                                         
   V144 '012B17C:#X NARC/LAST30DA'                                         
   V145 '012B18A:#X INHL/LIFETIME'                                         
   V146 '012B18B:#X INHL/LAST12MO'                                         
   V147 '012B18C:#X INHL/LAST30DA'                                         
   V148 '012(R)  :AGE <>18 DICHOTOMY'                                      
   V150 "012C03 :R'S SEX"                                                  
   V151 "012C04(R)R'S RACE"                                                
   V152 '012C05 :R SPD >TIM R-URB'                                         
   V153 '012C06 :R NOT MARRIED'                                            
   V155 "012C07Cb(R):R'S HSHLD FATHER"                                     
   V156 "012C07Cc(R):R'S HSHLD MOTHER"                                     
   V157 "012C07Cd(R):R'S HSHLD BR/SR"                                      
   V163 '012C08 :FATHR EDUC LEVEL'                                         
   V164 '012C09 :MOTHR EDUC LEVEL'                                         
   V165 '012C10 :MOTH PD JB R YNG'                                         
   V166 "012C11 :R'S POLTL PRFNC"                                          
   V167 "012C12 :R'POL BLF RADCL"                                          
   V169 "012C13B:R'ATTND REL SVC"                                          
   V170 "012C13C:RLGN IMP R'S LF"                                          
   V171 '012C14 :WHEN R XPCT GRAD'                                         
   V172 "012C15 :R'S HS PROGRAM"                                           
   V173 '012C16 :RT SF SCH AB>AVG'                                         
   V174 '012C17 :RT SF INTELL>AVG'                                         
   V175 '012C18A:#DA/4W SC MS ILL'                                         
   V176 '012C18B:#DA/4W SC MS CUT'                                         
   V177 '012C18C:#DA/4W SC MS OTH'                                         
   V178 '012C19 :#DA/4W SKP CLASS'                                         
   V179 '012C20 :R HS GRADE/D=1'                                           
   V180 '012C21A:R WL DO VOC/TEC'                                          
   V181 '012C21B:R WL DO ARMD FC'                                          
   V182 '012C21C:R WL DO 2YR CLG'                                          
   V183 '012C21D:R WL DO 4YR CLG'                                          
   V184 '012C21E:R WL DO GRD/PRF'                                          
   V185 '012C22A:R WNTDO VOC/TEC'                                          
   V186 '012C22B:R WNTDO ARMD FC'                                          
   V187 '012C22C:R WNTDO 2YR CLG'                                          
   V188 '012C22D:R WNTDO 4YR CLG'                                          
   V189 '012C22E:R WNTDO GRD/PRF'                                          
   V190 '012C22F:R WNTDO NONE'                                             
   V191 '012C23 :HRS/W WRK SCHYR'                                          
   V192 '012C24A:R$/AVG WEEK JOB'                                          
   V193 '012C24B:R$/AVG WEEK OTH'                                          
   V194 '012C25 :#X/AV WK GO OUT'                                          
   V195 '012C26 :#X DATE 3+/WK'                                            
   V196 '012C27 :DRIVE>200 MI/WK'                                          
   V197 '012C28 :#X/12MO R TCKTD'                                          
   V198 '012C29AR#TCKTS AFT DRNK'                                          
   V199 '012C29BR#TCKTS AFT MARJ'                                          
   V200 '012C29CR#TCKTS AFT OTDG'                                          
   V201 '012C30 :#ACCIDNTS/12 MO'                                          
   V202 '012C31AR#ACDTS AFT DRNK'                                          
   V203 '012C31BR#ACDTS AFT MARJ'                                          
   V204 '012C31CR#ACDTS AFT OTDG'                                          
   V109 '011B018A:#X HASH/LIFETIM'                                         
   V110 '011B018B:#X HASH/LAST12M'                                         
   V111 '011B018C:#X HASH/LAST30D'                                         
   V112 '011B019A:#X MARJ/LIFETIM'                                         
   V113 '011B019B:#X MARJ/LAST12M'                                         
   V114 '011B019C:#X MARJ/LAST30D'                                         
   V205 "0115C32  :R'S BRANCH SERV"                                        
   V206 '0115C33  :R XPCTS B OFFCR'                                        
   V207 '0115C34  :R XPCTS MLTR CR'                                        
   CASEID 'CASE IDENTIFICATION NUMBER' .                                   
                                                                           
* SPSS MISSING VALUES COMMAND.                                             
                                                                           
*MISSING VALUES                                                            
  V13 (-9)                 V16 (-9)                 V17 (-9)               
  V5 (-9)                  V1 (-9)                  V3 (-9)                
  V4 (-9)                  V130 (-9)                V131 (-9)              
  V132 (-9)                V49 (-9)                 V101 (-9)              
  V102 (-9)                V103 (-9)                V104 (-9)              
  V105 (-9)                V106 (-9)                V107 (-9)              
  V108 (-9)                V115 (-9)                V116 (-9)              
  V117 (-9)                V118 (-9)                V119 (-9)              
  V120 (-9)                V121 (-9)                V122 (-9)              
  V123 (-9)                V124 (-9)                V125 (-9)              
  V126 (-9)                V127 (-9)                V128 (-9)              
  V129 (-9)                V133 (-9)                V134 (-9)              
  V135 (-9)                V136 (-9)                V137 (-9)              
  V138 (-9)                V139 (-9)                V140 (-9)              
  V141 (-9)                V142 (-9)                V143 (-9)              
  V144 (-9)                V145 (-9)                V146 (-9)              
  V147 (-9)                V148 (-9)                V150 (-9)              
  V151 (-9)                V152 (-9)                V153 (-9)              
  V155 (-9)                V156 (-9)                V157 (-9)              
  V163 (-9)                V164 (-9)                V165 (-9)              
  V166 (-9)                V167 (-9)                V169 (-9)              
  V170 (-9)                V171 (-9)                V172 (-9)              
  V173 (-9)                V174 (-9)                V175 (-9)              
  V176 (-9)                V177 (-9)                V178 (-9)              
  V179 (-9)                V180 (-9)                V181 (-9)              
  V182 (-9)                V183 (-9)                V184 (-9)              
  V185 (-9)                V186 (-9)                V187 (-9)              
  V188 (-9)                V189 (-9)                V190 (-9)              
  V191 (-9)                V192 (-9)                V193 (-9)              
  V194 (-9)                V195 (-9)                V196 (-9)              
  V197 (-9)                V198 (-9)                V199 (-9)              
  V200 (-9)                V201 (-9)                V202 (-9)              
  V203 (-9)                V204 (-9)                V109 (-9)              
  V110 (-9)                V111 (-9)                V112 (-9)              
  V113 (-9)                V114 (-9)                V205 (-9)              
  V206 (-9)                V207 (-9)                CASEID (-9) .          
                                                                           
* SPSS VALUE LABELS COMMAND.                                               
                                                                           
VALUE LABELS                                                               
 V13                                                                       
     -9 'MISSING'                                                          
     1 'NE'                                                                
     2 'NC'                                                                
     3 'S'                                                                 
     4 'W' /                                                               
 V130                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V131                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V132                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V49                                                                       
     -9 'MISSING'                                                          
     3 '3 OR MORE' /                                                       
 V101                                                                      
     -9 'MISSING'                                                          
     1 'NEVER:(1)'                                                         
     2 '1-2X:(2)'                                                          
     3 'OCCASNLY:(3)'                                                      
     4 'REG PAST:(4)'                                                      
     5 'REG NOW:(5)' /                                                     
 V102                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '<1 CIG/D:(2)'                                                      
     3 '1-5/DAY:(3)'                                                       
     4 '1/2PK/D:(4)'                                                       
     5 '1 PK/DA:(5)'                                                       
     6 '1.5 PK/D:(6)'                                                      
     7 '2+ PKS/D:(7)' /                                                    
 V103                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'YES:(2)' /                                                         
 V104                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V105                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V106                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V107                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 'FEW:(2)'                                                           
     3 'HALF:(3)'                                                          
     4 'MOST:(4)'                                                          
     5 'NRLY ALL:(5)' /                                                    
 V108                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 'ONCE:(2)'                                                          
     3 'TWICE:(3)'                                                         
     4 '3-5X:(4)'                                                          
     5 '6-9X:(5)'                                                          
     6 '10+ TIME:(6)' /                                                    
 V115                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V116                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V117                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V118                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V119                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V120                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V121                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V122                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V123                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V124                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V125                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V126                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V127                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V128                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V129                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V133                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V134                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V135                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V136                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V137                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V138                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V139                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V140                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V141                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V142                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V143                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V144                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V145                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V146                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V147                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V148                                                                      
     -9 'MISSING'                                                          
     1 '< 18'                                                              
     2 '18+' /                                                             
 V150                                                                      
     -9 'MISSING'                                                          
     1 'MALE:(1)'                                                          
     2 'FEMALE:(2)' /                                                      
 V151                                                                      
     -9 'MISSING'                                                          
     0 'WHITE:(6)'                                                         
     1 'BLACK:(2)' /                                                       
 V152                                                                      
     -9 'MISSING'                                                          
     0 'DK/MIXED:(0)'                                                      
     1 'FARM:(1)'                                                          
     2 'COUNTRY:(2)'                                                       
     3 'SML TOWN:(3)'                                                      
     4 'MED CITY:(4)'                                                      
     5 'SUBURB 4:(5)'                                                      
     6 'LRG CITY:(6)'                                                      
     7 'SUBURB 6:(7)'                                                      
     8 'VRYLG CY:(8)'                                                      
     9 'SUBURB 8:(9)' /                                                    
 V153                                                                      
     -9 'MISSING'                                                          
     1 'MARRIED:(1)'                                                       
     2 'ENGAGED:(2)'                                                       
     3 'SEP/DIV:(3)'                                                       
     4 'SINGLE:(4)' /                                                      
 V155                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V156                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V157                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V163                                                                      
     -9 'MISSING'                                                          
     1 'GRDE SCH:(1)'                                                      
     2 'SOME HS:(2)'                                                       
     3 'HS GRAD:(3)'                                                       
     4 'SOME CLG:(4)'                                                      
     5 'CLG GRAD:(5)'                                                      
     6 'GRAD SCH:(6)'                                                      
     7 'DK/NA:(7)' /                                                       
 V164                                                                      
     -9 'MISSING'                                                          
     1 'GRDE SCH:(1)'                                                      
     2 'SOME HS:(2)'                                                       
     3 'HS GRAD:(3)'                                                       
     4 'SOME CLG:(4)'                                                      
     5 'CLG GRAD:(5)'                                                      
     6 'GRAD SCH:(6)'                                                      
     7 'DK/NA:(7)' /                                                       
 V165                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'SOMETIME:(2)'                                                      
     3 'MOSTTIME:(3)'                                                      
     4 'ALL TIME:(4)' /                                                    
 V166                                                                      
     -9 'MISSING'                                                          
     1 'STRG GOP:(1)'                                                      
     2 'MILD GOP:(2)'                                                      
     3 'MILD DEM:(3)'                                                      
     4 'STRG DEM:(4)'                                                      
     5 'INDEPNDT:(5)'                                                      
     6 'NO PREF:(6)'                                                       
     7 'OTHER:(7)' /                                                       
 V167                                                                      
     -9 'MISSING'                                                          
     1 'VRY CONS:(1)'                                                      
     2 'CONSERV:(2)'                                                       
     3 'MODERATE:(3)'                                                      
     4 'LIBERAL:(4)'                                                       
     5 'VRY LIB:(5)'                                                       
     6 'RADICAL:(7)' /                                                     
 V169                                                                      
     -9 'MISSING'                                                          
     1 'NEVER:(1)'                                                         
     2 'RARELY:(2)'                                                        
     3 '1-2X/MO:(3)'                                                       
     4 '1/WK OR+:(4)' /                                                    
 V170                                                                      
     -9 'MISSING'                                                          
     1 'NOT IMPT:(1)'                                                      
     2 'LITL IMP:(2)'                                                      
     3 'PRTY IMP:(3)'                                                      
     4 'VERY IMP:(4)' /                                                    
 V171                                                                      
     -9 'MISSING'                                                          
     1 'BY JUNE:(1)'                                                       
     2 'JULY-JAN:(2)'                                                      
     3 'AFT JAN:(3)'                                                       
     6 'WONT:(6)' /                                                        
 V172                                                                      
     -9 'MISSING'                                                          
     1 'CLG PREP:(1)'                                                      
     2 'GENERAL:(2)'                                                       
     3 'VOC-TECH:(3)'                                                      
     4 'OTH/DK:(4)' /                                                      
 V173                                                                      
     -9 'MISSING'                                                          
     1 'FAR BLOW:(1)'                                                      
     2 'BELOW AV:(2)'                                                      
     3 'SL BELOW:(3)'                                                      
     4 'AVERAGE:(4)'                                                       
     5 'SL ABOVE:(5)'                                                      
     6 'ABOVE AV:(6)'                                                      
     7 'FAR ABOV:(7)' /                                                    
 V174                                                                      
     -9 'MISSING'                                                          
     1 'FAR BLOW:(1)'                                                      
     2 'BELOW AV:(2)'                                                      
     3 'SL BELOW:(3)'                                                      
     4 'AVERAGE:(4)'                                                       
     5 'SL ABOVE:(5)'                                                      
     6 'ABOVE AV:(6)'                                                      
     7 'FAR ABOV:(7)' /                                                    
 V175                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1 DAY:(2)'                                                         
     3 '2 DAYS:(3)'                                                        
     4 '3 DAYS:(4)'                                                        
     5 '4-5 DAYS:(5)'                                                      
     6 '6-10 DA:(6)'                                                       
     7 '11+ DAYS:(7)' /                                                    
 V176                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1 DAY:(2)'                                                         
     3 '2 DAYS:(3)'                                                        
     4 '3 DAYS:(4)'                                                        
     5 '4-5 DAYS:(5)'                                                      
     6 '6-10 DA:(6)'                                                       
     7 '11+ DAYS:(7)' /                                                    
 V177                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1 DAY:(2)'                                                         
     3 '2 DAYS:(3)'                                                        
     4 '3 DAYS:(4)'                                                        
     5 '4-5 DAYS:(5)'                                                      
     6 '6-10 DA:(6)'                                                       
     7 '11+ DAYS:(7)' /                                                    
 V178                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1-2:(2)'                                                           
     3 '3-5:(3)'                                                           
     4 '6-10:(4)'                                                          
     5 '11-20:(5)'                                                         
     6 '21+:(6)' /                                                         
 V179                                                                      
     -9 'MISSING'                                                          
     1 'D:(1)'                                                             
     2 'C-:(2)'                                                            
     3 'C:(3)'                                                             
     4 'C+:(4)'                                                            
     5 'B-:(5)'                                                            
     6 'B:(6)'                                                             
     7 'B+:(7)'                                                            
     8 'A-:(8)'                                                            
     9 'A:(9)' /                                                           
 V180                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V181                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V182                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V183                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V184                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V185                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V186                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V187                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V188                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V189                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V190                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V191                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '5 OR <:(2)'                                                        
     3 '6-10 HRS:(3)'                                                      
     4 '11-15 HR:(4)'                                                      
     5 '16-20 HR:(5)'                                                      
     6 '21-25 HR:(6)'                                                      
     7 '26-30 HR:(7)'                                                      
     8 '30+ HRS:(8)' /                                                     
 V192                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '$1-5:(2)'                                                          
     3 '$6-10:(3)'                                                         
     4 '$11-20:(4)'                                                        
     5 '$21-35:(5)'                                                        
     6 '$36-50:(6)'                                                        
     7 '$51-75:(7)'                                                        
     8 '$76-125:(8)'                                                       
     9 '$126+:(9)' /                                                       
 V193                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '$1-5:(2)'                                                          
     3 '$6-10:(3)'                                                         
     4 '$11-20:(4)'                                                        
     5 '$21-35:(5)'                                                        
     6 '$36-50:(6)'                                                        
     7 '$51-75:(7)'                                                        
     8 '$76-125:(8)'                                                       
     9 '$126+:(9)' /                                                       
 V194                                                                      
     -9 'MISSING'                                                          
     1 '< 1:(1)'                                                           
     2 'ONE:(2)'                                                           
     3 'TWO:(3)'                                                           
     4 'THREE:(4)'                                                         
     5 '4-5:(5)'                                                           
     6 '6-7:(6)' /                                                         
 V195                                                                      
     -9 'MISSING'                                                          
     1 'NEVER:(1)'                                                         
     2 '1/MO OR<:(2)'                                                      
     3 '2-3/MO:(3)'                                                        
     4 '1/WK:(4)'                                                          
     5 '2-3/WK:(5)'                                                        
     6 '3+/WK:(6)' /                                                       
 V196                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1-10 MI:(2)'                                                       
     3 '11-50:(3)'                                                         
     4 '51-100:(4)'                                                        
     5 '101-200:(5)'                                                       
     6 '> 200:(6)' /                                                       
 V197                                                                      
     -9 'MISSING'                                                          
     0 'NONE:(0)'                                                          
     1 'ONE:(1)'                                                           
     2 'TWO:(2)'                                                           
     3 'THREE:(3)'                                                         
     4 '4+:(4)' /                                                          
 V198                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V199                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V200                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V201                                                                      
     -9 'MISSING'                                                          
     0 'NONE:(0)'                                                          
     1 'ONE:(1)'                                                           
     2 'TWO:(2)'                                                           
     3 'THREE:(3)'                                                         
     4 '4+:(4)' /                                                          
 V202                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V203                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V204                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V109                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V110                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V111                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V112                                                                      
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)'                                                      
     -9 'MISSING'  /                                                       
 V113                                                                      
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)'                                                      
     -9 'MISSING' /                                                        
 V114                                                                      
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)'                                                      
    -9 'MISSING'  /                                                        
 V205                                                                      
     -9 'MISSING'                                                          
     1 'ARMY:(1)'                                                          
     2 'NAVY:(2)'                                                          
     3 'MARINES:(3)'                                                       
     4 'AIRFORCE:(4)'                                                      
     5 'COAST GD:(5)'                                                      
     6 'UNCERTN:(6)' /                                                     
 V206                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'UNCERTN:(2)'                                                       
     3 'YES:(3)' /                                                         
 V207                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'UNCERTN:(2)'                                                       
     3 'YES:(3)' / .                                                       
                                                                           
* Create SPSS system file.                                                 
                                                                           
*save outfile="spss-filename.sav".                                         
