% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_values.R
\name{assert_values}
\alias{assert_values}
\title{Assert that a data.frame's columns are non-NA/infinite, or are greater, less than, equal/not-equal, or contain specified values.}
\usage{
assert_values(data, colnames, test = "not_na", test_val = NA,
  display_rows = TRUE, na.rm = FALSE, warn_only = FALSE)
}
\arguments{
\item{data}{A data.frame or data.table}

\item{colnames}{Character vector with column names corresponding to columns in \emph{data}}

\item{test}{The type of evaluation you want to assert in your data
\itemize{
  \item \emph{not_na}:      All values must not be Na
  \item \emph{not_nan}:     All values must not be NaN
  \item \emph{not_inf}:     All values must not be infinite
  \item \emph{lt}:          All values must be less than test_val
  \item \emph{lte}:         All values must be less than or equal to test_val
  \item \emph{gt}:          All values must be greater than test_val
  \item \emph{gte}:         All values must be greater than or equal to test_val
  \item \emph{equal}:       All values must be equal to test_val
  \item \emph{not_equal}:   All values must not equal test_val
  \item \emph{in}:          All values must be one of the values in test_val
}}

\item{test_val}{A single value, a vector with length = nrow(data), or a vector of any length (if using the \emph{in} option for test. 
Must match the character type of colnames.}

\item{display_rows}{Do you want to show the actual rows that violate the assertion? Default=T}

\item{na.rm}{Do you want to remove NA and NaN values from assertions? Default=F}

\item{warn_only}{Do you want to warn, rather than error? Will return all offending rows from the first violation of the assertion Default=F}
}
\value{
Throws error if test is violated. If warn_only=T, will return all offending rows from the first violation of the assertion.
}
\description{
Given a data.frame or data.table object, make assertions about values of the columns within the object.
Assert that a column contains no missing/infinite values, or that it is greater/less than, equal to, or contains 
either a single value, vector with nrow(data) values, or a vector of any length(for \emph{in} option).
}
\examples{
assert_values(CO2, colnames="uptake", test="gt", 0) # Are all values greater than 0?
assert_values(CO2, colnames="conc", test="lte", 1000) # Are all values less than/equal to 1000?
\dontrun{
 assert_values(CO2, colnames="uptake", test="lt", 40) # Are all values less than 40?
 # Fails: not all values < 40.
}
assert_values(CO2, colnames="Treatment", test="in", test_val = c("nonchilled","chilled"))
CO2_mult <- CO2
CO2_mult$new_uptake <- CO2_mult$uptake * 2
assert_values(CO2, colnames="uptake", test="equal", CO2_mult$new_uptake/2)
\dontrun{
 assert_values(CO2, colnames="uptake", test="gt", CO2_mult$new_uptake/2, display_rows=F)
 # Fails: uptake !> new_uptake/2
}
}

