% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locale.R
\name{sys_get_locale}
\alias{sys_get_locale}
\alias{sys_set_locale}
\title{Get or set the system locale}
\usage{
sys_get_locale(simplify = FALSE, remove_empty_categories = TRUE)

sys_set_locale(..., l = list())
}
\arguments{
\item{simplify}{If \code{TRUE}, the locale settings are returned as a 
character vector, otherwise a list.}

\item{remove_empty_categories}{if \code{TRUE}, don't include empty categories.}

\item{...}{Name-value pairs of locale categories to set.}

\item{l}{A list, as an alternative method of passing local categories to set.}
}
\value{
A named list or vector giving the system locale names. 
\code{sys_set_locale} invisibly returns the locale settings *before* making 
changes (like \code{setwd} and \code{options} do).
}
\description{
Wrappers to \code{Sys.getlocale} and \code{Sys.setlocale} for getting and
setting the system locale.
}
\examples{
(current_locale <- sys_get_locale())

# Output simplified to character vector
sys_get_locale(simplify = TRUE)
\dontrun{
# Not run since it (temporarily) affects system settings
english <- if(is_windows()) "English.United_Kingdom" else 
  if(is_mac()) "en_GB" else 
  if(is_linux()) "en_GB.utf8" else
  "en"
sys_set_locale(LC_MONETARY = english)
sys_get_locale()
sys_set_locale(l = current_locale)  #restore everything
}
}
\seealso{
\code{\link[base]{Sys.getlocale}}.
}
