% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assertions.R
\name{insist}
\alias{insist}
\title{Raises error if dynamically created predicate is FALSE in any columns selected}
\usage{
insist(data, predicate_generator, ...)
}
\arguments{
\item{data}{A data frame}

\item{predicate_generator}{A function that is applied
to each of the column vectors selected. This will produce,
for every column, a true predicate function to be applied to
every element in the column vectors selected}

\item{...}{Comma separated list of unquoted expressions.
           You can treat variable names like they are positions.
           Use positive values to select variables; use negative
           values to drop variables.}
}
\value{
data if dynamically created predicate assertion is TRUE. error if not.
}
\description{
Meant for use in a data analysis pipeline, this function applies a predicate
generating function to each of the columns indicated. It will then use these
predicates to check every element of those columns. If any of these
predicate applications yield FALSE, this function will raise an error,
effectively terminating the pipeline early. If there are no FALSES, this
function will just return the data that it was supplied for further use in
later parts of the pipeline.
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{
insist(iris, within_n_sds(3), Sepal.Length)   # returns iris

library(magrittr)

iris \%>\%
  insist(within_n_sds(4), Sepal.Length:Petal.Width)
  # anything here will run

\dontrun{
iris \%>\%
  insist(within_n_sds(3), Sepal.Length:Petal.Width)
  # datum at index 16 of 'Sepal.Width' vector is (4.4)
  # is outside 3 standard deviations from the mean of Sepal.Width.
  # The check fails, raises a fatal error, and the pipeline
  # is terminated so nothing after this statement will run}
}
\seealso{
\code{\link{assert}} \code{\link{verify}}
}

