% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Receiver Operating Characteristic (ROC)}
\usage{
plotROC(object, ...)
}
\arguments{
\item{object}{An object of class ModelAudit or modelEvaluation.}

\item{...}{Other modelAudit objects to be plotted together.}
}
\value{
ggplot object
}
\description{
Receiver Operating Characterstic Curve is a plot of the true positive rate (TPR) against the false positive rate (FPR) for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
library(mlbench)
data("PimaIndiansDiabetes")
Pima <- PimaIndiansDiabetes
Pima$diabetes <- ifelse(Pima$diabetes == "pos", 1, 0)
glm_model <- glm(diabetes~., family=binomial,	data=Pima)
glm_au <- audit(glm_model, data = Pima, y = Pima$diabetes)
plotROC(glm_au)

}
\seealso{
\code{\link{plot.modelAudit}, \link{plotRROC}, \link{plotREC}}
}
