% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scalelocation.R
\name{plot_scalelocation}
\alias{plot_scalelocation}
\alias{plotScaleLocation}
\title{Scale location plot}
\usage{
plot_scalelocation(
  object,
  ...,
  variable = "_y_",
  smooth = FALSE,
  peaks = FALSE
)

plotScaleLocation(object, ..., variable = NULL, smooth = FALSE, peaks = FALSE)
}
\arguments{
\item{object}{An object of class \code{auditor_model_residual} created with \code{\link{model_residual}} function.}

\item{...}{Other \code{auditor_model_residual} objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the data on the plot will be ordered by predicted response.
If \code{variable = NULL}, unordered observations are presented.}

\item{smooth}{Logical, indicates whenever smoothed lines should be added. By default it's \code{FALSE}.}

\item{peaks}{A logical value. If \code{TRUE} peaks are marked on plot by black dots.}
}
\value{
A ggplot object.
}
\description{
Variable values vs square root of the absolute value of the residuals.
A vertical line corresponds to median.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plot_scalelocation(mr_lm)
plot(mr_lm, type = "scalelocation")

}
