% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_model_halfnormal}
\alias{print.auditor_model_halfnormal}
\title{Prints Model Halfnormal Summary}
\usage{
\method{print}{auditor_model_halfnormal}(x, ...)
}
\arguments{
\item{x}{an object \code{auditor_model_halfnormal} created with \code{\link{model_halfnormal}} function.}

\item{...}{other parameters}
}
\description{
Prints Model Halfnormal Summary
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
model_halfnormal(glm_audit)


}
