% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaze_sub.R
\name{gazeCat}
\alias{gazeCat}
\title{Summary function for categorical variable}
\usage{
gazeCat(
  data,
  x,
  y = NULL,
  max.ylev = 5,
  digits = 1,
  show.total = FALSE,
  show.n = FALSE,
  show.missing = FALSE,
  show.stats = TRUE,
  origData = NULL,
  show.p = TRUE,
  method = 1,
  catMethod = 2,
  maxCatLevel = 20,
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{x}{Name of a categorical variable}

\item{y}{Name of a variable, either continuous or categorical}

\item{max.ylev}{max.ylev An integer indicating the maximum number of levels of grouping variable ('y').
If a column have unique values less than max.ylev it is treated as a categorical variable. Default value is 5.}

\item{digits}{Numeric}

\item{show.total}{logical. Whether or not show total column}

\item{show.n}{logical. Whether or not show N column}

\item{show.missing}{logical. Whether or not show missing column}

\item{show.stats}{logical. Whether or not show stats column}

\item{origData}{A data.frame containing original data}

\item{show.p}{logical. Whether or not show p column}

\item{method}{method    An integer indicating methods for continuous variables. Possible values in methods are
1 forces analysis as normal-distributed
2 forces analysis as continuous non-normal
3 performs a Shapiro-Wilk test or nortest::ad.test to decide between normal or non-normal
Default value is 1.}

\item{catMethod}{An integer indicating methods for categorical variables.
Possible values in methods are
\describe{
   \item{0}{Perform chisq.test first. If warning present, perform fisher test}
   \item{1}{Perform chisq.test without continuity correction}
   \item{2}{Perform chisq.test with continuity correction}
   \item{3}{perform fisher.test}
   \item{4}{perform prop.trend test}
}
Default value is 2.}

\item{maxCatLevel}{An integer indicating the maximum number of unique levels of categorical variable.
If a column have unique values more than maxCatLevel, categorical summarization will not be performed.}

\item{...}{Further arguments}
}
\value{
An object of class "data.frame" or "tibble"
}
\description{
Summary function for categorical variable
}
\examples{
require(moonBook)
gazeCat(acs,"Dx")
gazeCat(acs,"Dx","smoking")
gazeCat(acs,"sex","Dx",show.p=TRUE)
gazeCat(acs,"Dx","sex",show.p=TRUE)
gazeCat(acs,"Dx","EF")
gazeCat(acs,"sex","EF",method=2)
gazeCat(mtcars,"cyl","hp")
}
