% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.AutokerasModel}
\title{Model Predictions}
\usage{
\method{predict}{AutokerasModel}(object, x, batch_size = 32, ...)
}
\arguments{
\item{object}{: A trained AutokerasModel instance.}

\item{x}{: Any allowed types according to the input node. Testing data. Check
corresponding AutokerasModel help to note how it should be provided.}

\item{batch_size}{: numeric. Defaults to `32`.}

\item{...}{: Unused.}
}
\value{
A one-column matrix with the predicted values as rows.
}
\description{
Predict the output for a given testing data.
}
\examples{
\dontrun{
library("keras")

# use the MNIST dataset as an example
mnist <- dataset_mnist()
c(x_train, y_train) \%<-\% mnist$train
c(x_test, y_test) \%<-\% mnist$test

library("autokeras")

# Initialize the image classifier
clf <- model_image_classifier(max_trials = 10) \%>\% # It tries 10 different models
  fit(x_train, y_train) # Feed the image classifier with training data

# Predict with the best model
(predicted_y <- clf \%>\% predict(x_test))

# Evaluate the best model with testing data
clf \%>\% evaluate(x_test, y_test)

# Get the best trained Keras model, to work with the keras R library
export_model(clf)
}

}
