% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_slides.R
\name{generate_slides}
\alias{generate_slides}
\title{generate slides based on output}
\usage{
generate_slides(
  outputs,
  outfile = paste0(tempdir(), "/output.pptx"),
  template = file.path(system.file(package = "autoslider.core"), "theme/basic.pptx"),
  fig_width = 9,
  fig_height = 5,
  t_lpp = 20,
  t_cpp = 200,
  l_lpp = 20,
  l_cpp = 150,
  fig_editable = FALSE,
  ...
)
}
\arguments{
\item{outputs}{List of output}

\item{outfile}{Out file path}

\item{template}{Template file path}

\item{fig_width}{figure width in inch}

\item{fig_height}{figure height in inch}

\item{t_lpp}{An integer specifying the table lines per page \cr
Specify this optional argument to modify the length of all of the table displays}

\item{t_cpp}{An integer specifying the table columns per page\cr
Specify this optional argument to modify the width of all of the table displays}

\item{l_lpp}{An integer specifying the listing lines per page\cr
Specify this optional argument to modify the length of all of the listings display}

\item{l_cpp}{An integer specifying the listing columns per page\cr
Specify this optional argument to modify the width of all of the listings display}

\item{fig_editable}{whether we want the figure to be editable in pptx viewers, defaults to FALSE}

\item{...}{arguments passed to program}
}
\value{
No return value, called for side effects
}
\description{
generate slides based on output
}
\examples{
\dontshow{if (require(filters)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Example 1. When applying to the whole pipeline
library(dplyr)
data <- list(
  adsl = eg_adsl \%>\% dplyr::mutate(FASFL = SAFFL),
  adae = eg_adae
)


filters::load_filters(
  yaml_file = system.file("filters.yml", package = "autoslider.core"),
  overwrite = TRUE
)


spec_file <- system.file("spec.yml", package = "autoslider.core")
spec_file \%>\%
  read_spec() \%>\%
  filter_spec(program \%in\% c("t_dm_slide")) \%>\%
  generate_outputs(datasets = data) \%>\%
  decorate_outputs() \%>\%
  generate_slides()

# Example 2. When applying to an rtable object or an rlisting object
adsl <- eg_adsl
t_dm_slide(adsl, "TRT01P", c("SEX", "AGE")) \%>\%
  generate_slides()
\dontshow{\}) # examplesIf}
}
