% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_ssm.R
\name{stsm_ssm}
\alias{stsm_ssm}
\title{State space model}
\usage{
stsm_ssm(
  par = NULL,
  yt = NULL,
  freq = NULL,
  decomp = NULL,
  trend = NULL,
  init = NULL,
  model = NULL
)
}
\arguments{
\item{par}{Vector of named parameter values, includes the harmonics}

\item{yt}{Univariate time series of data values}

\item{freq}{Frequency of the data (1 (yearly), 4 (quarterly), 12 (monthly), 365.25/7 (weekly), 365.25 (daily))}

\item{decomp}{Decomposition model ("tend-cycle-seasonal", "trend-seasonal", "trend-cycle", "trend-noise")}

\item{trend}{Trend specification ("random-walk", "random-walk-drift", "double-random-walk", "random-walk2"). The default is NULL which will choose the best of all specifications based on the maximum likielhood.
"random-walk" is the random walk trend.
"random-walk-drift" is the random walk with constant drift trend.
"double-random-walk" is the random walk with random walk drift trend.
"random-walk2" is a 2nd order random walk trend as in the Hodrick-Prescott filter.}

\item{init}{Initial state values for the Kalman filter}

\item{model}{a stsm_estimate model object}
}
\value{
List of space space matrices
}
\description{
Creates a state space model in list form
yt = H*B + e_t
B = F*B_{t-1} + u_t
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
stsm = stsm_estimate(NA000334Q)
ssm = stsm_ssm(model = stsm)
}
}
