% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/needs_trend.r
\name{needs_trend}
\alias{needs_trend}
\title{Determines if a trend is required for the specified VAR model}
\usage{
needs_trend(endo_matrix, lag)
}
\arguments{
\item{endo_matrix}{The matrix of endogenous variables in the model.}

\item{lag}{An integer specifying the lag length of the model.}
}
\value{
A boolean indicating whether a trend is required for the specified VAR model.
}
\description{
This function uses the Phillips-Perron Unit Root Test to determine whether a trend is required for a VAR model based on the given matrix of endogenous variables and the given lag. All variables are assessed individually. This function returns \code{TRUE} if any of the endogenous variables requires a trend.
}
\examples{
data_matrix <- matrix(nrow = 40, ncol = 3)
data_matrix[, ] <- runif(ncol(data_matrix) * nrow(data_matrix), 1, 10)
data_matrix[, 3] <- (1:40) + rnorm(40)
colnames(data_matrix) <- c('rumination', 'happiness', 'activity')
data_matrix
autovarCore:::needs_trend(data_matrix, 1)
}

