% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genome_id_from_logic_operation.R
\name{get_genome_id_from_logic_operation}
\alias{get_genome_id_from_logic_operation}
\title{Get genome from logic operations}
\usage{
get_genome_id_from_logic_operation(
  logic_operation,
  seed_id = sample(1:1000, 1),
  genome_seq = FALSE,
  triplestore
)
}
\arguments{
\item{logic_operation}{List of logical operations from the following set:
"equals", "exclusive-or", "not-or", "and-not", "or", "orn-not", "and",
"not-and", "not".}

\item{seed_id}{Integer (from 1 to 1000) or a vector of integer values. This
integer is used for starting the pseudo-random number generator that
represents the environment experiencing a digital organism. If seed_id value
is not specified, it returns data for a single randomly chosen seed_id value
(between 1 and 1000).}

\item{genome_seq}{Logical value (TRUE/FALSE) to show/hide this column
("FALSE" by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "seed_id" (optional), "genome_id", "genome_seq" (optional).
}
\description{
Get the genome of a digital organism that encodes a unique
combination of logic operations for a list of seeds used for starting the
pseudo-random number generator (i.e., a set of environments).
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single logic operation
get_genome_id_from_logic_operation(
  logic_operation = "not-or",
  triplestore = avidaDB
)

# More than one logic operation
get_genome_id_from_logic_operation(
  logic_operation = c("not", "not-and"),
  triplestore = avidaDB
)

# At seed_1
get_genome_id_from_logic_operation(
  logic_operation = c("or", "equals", "and"),
  seed_id = 1,
  genome_seq = TRUE,
  triplestore = avidaDB
)

}
