% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category_listing.R
\name{category_listing}
\alias{category_listing}
\title{Category Listing}
\usage{
category_listing(path = NULL, sort_by = "Popularity", recursive = TRUE,
  start = 0, count = 20, description = TRUE, ...)
}
\arguments{
\item{path}{String; Required; valid category path}

\item{sort_by}{sort results by Popularity, Title, or AverageReview}

\item{recursive}{Boolean; Whether to return listings for the current 
category only, or for the current category plus all subcategories, 
Default is TRUE}

\item{start}{index of result at which to start; default is 0}

\item{count}{Number of results to return for this request; 
Max = 20; Default = 20}

\item{description}{Boolean; Optional; Whether or not to return descriptions 
of categories; Default is TRUE}

\item{\dots}{Additional arguments passed to \code{\link{alexa_GET}}.}
}
\value{
data.frame
}
\description{
Uses data from \url{http://www.dmoz.org}. For any given category, 
it returns a list of site listings contained within that category.
}
\examples{
\dontrun{
category_listing(path="Top/Arts")
}
}
\references{
\url{http://docs.aws.amazon.com/AlexaWebInfoService/latest/ApiReference_CategoryListingsAction.html}
}
