% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_launch_template_versions}
\alias{ec2_delete_launch_template_versions}
\title{Delete Launch Template Versions}
\usage{
ec2_delete_launch_template_versions(
  LaunchTemplateVersion,
  DryRun = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{LaunchTemplateVersion}{List. The version numbers of one or more launch template versions to delete.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{LaunchTemplateId}{String. The ID of the launch template.[optional]}

\item{LaunchTemplateName}{String. The name of the launch template.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes one or more versions of a launch
template. You cannot delete the default version of a launch template;
you must first assign a different version as the default. If the default
version is the only version for the launch template, you must delete the
entire launch template using
DeleteLaunchTemplate.
}
\section{LaunchTemplateVersion}{

The version numbers of
one or more launch template versions to
delete.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{LaunchTemplateId}{

The ID of the launch
template. You must specify either the launch template ID or launch
template name in the request.
}

\section{LaunchTemplateName}{

The name of the launch
template. You must specify either the launch template ID or launch
template name in the request.
}

