% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_network_insights_paths}
\alias{ec2_describe_network_insights_paths}
\title{Describe Network Insights Paths}
\usage{
ec2_describe_network_insights_paths(
  NetworkInsightsPathId = NULL,
  Filter = NULL,
  MaxResults = NULL,
  DryRun = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInsightsPathId}{List. The IDs of the paths.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more of your
paths.
}
\section{NetworkInsightsPathId}{

The IDs of the
paths.
}

\section{Filter}{


The filters. The following are possible values:
\itemize{
\item Destination - The ID of the resource.
\item DestinationPort - The destination port.
\item Name - The path name.
\item Protocol - The protocol.
\item Source - The ID of the resource.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you
have the required permissions for the action, without actually making
the request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

