% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_volume_attribute}
\alias{ec2_modify_volume_attribute}
\title{Modify Volume Attribute}
\usage{
ec2_modify_volume_attribute(
  VolumeId,
  AutoEnableIO = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VolumeId}{String. The ID of the volume.}

\item{AutoEnableIO}{Object. Indicates whether the volume should be auto-enabled for I/O operations.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Volume Attribute
}
\section{VolumeId}{

The ID of the
volume.
}

\section{AutoEnableIO}{

Indicates whether the volume should be
auto-enabled for I/O operations.
}

\section{DryRun}{

Checks whether you
have the required permissions for the action, without actually making
the request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

