% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_list_services}
\alias{ecs_list_services}
\title{List Services}
\usage{
ecs_list_services(
  maxResults = NULL,
  nextToken = NULL,
  cluster = NULL,
  launchType = NULL,
  schedulingStrategy = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{maxResults}{Character. Pagination limit[optional]}

\item{nextToken}{Characters. The token for the next page of results[optional]}

\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the services to list.}

\item{launchType}{Character. The launch type for the services to list.}

\item{schedulingStrategy}{Character. The scheduling strategy for services to list.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Lists the services that are running in a
specified cluster.
}
\section{maxResults}{

Pagination
limit
}

\section{cluster}{

The short
name or full Amazon Resource Name (ARN) of the cluster that hosts the
services to list. If you do not specify a cluster, the default cluster
is assumed.
}

\section{launchType}{

The launch type for the services to
list.
}

\section{schedulingStrategy}{

The scheduling strategy for services to
list.
}

