% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_register_task_definition}
\alias{ecs_register_task_definition}
\title{Register Task Definition}
\usage{
ecs_register_task_definition(
  family = NULL,
  taskRoleArn = NULL,
  executionRoleArn = NULL,
  networkMode = NULL,
  containerDefinitions = NULL,
  volumes = NULL,
  placementConstraints = NULL,
  requiresCompatibilities = NULL,
  cpu = NULL,
  memory = NULL,
  tags = NULL,
  pidMode = NULL,
  ipcMode = NULL,
  proxyConfiguration = NULL,
  inferenceAccelerators = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{family}{Character. You must specify a \code{family} for a task definition, which allows you to track multiple versions of...}

\item{taskRoleArn}{Character. The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can...}

\item{executionRoleArn}{Character. The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent...}

\item{networkMode}{Character.   The Docker networking mode to use for the containers in the task.}

\item{containerDefinitions}{List. A list of container definitions in JSON format that describe the different containers that make up...}

\item{volumes}{List. A list of volume definitions in JSON format that containers in your task may use.}

\item{placementConstraints}{List. An array of placement constraint objects to use for the task.}

\item{requiresCompatibilities}{List. The task launch type that Amazon ECS should validate the task definition against.}

\item{cpu}{Character.   The number of CPU units used by the task.}

\item{memory}{Character.   The amount of memory (in MiB) used by the task.}

\item{tags}{List.   The metadata that you apply to the task definition to help you categorize and organize them.}

\item{pidMode}{Character.   The process namespace to use for the containers in the task.}

\item{ipcMode}{Character.   The IPC resource namespace to use for the containers in the task.}

\item{proxyConfiguration}{No description can be found.}

\item{inferenceAccelerators}{List. The Elastic Inference accelerators to use for the containers in the task.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Register Task Definition
}
\section{family}{

You must specify a \code{family} for a task definition,
which allows you to track multiple versions of the same task definition.
The \code{family} is used as a name for your task definition. Up to 255
letters (uppercase and lowercase), numbers, and hyphens are
allowed.
}

\section{taskRoleArn}{

The short name or full Amazon Resource Name
(ARN) of the IAM role that containers in this task can assume. All
containers in this task are granted the permissions that are specified
in this role. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html}{IAM Roles for Tasks}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}

\section{executionRoleArn}{

The Amazon Resource Name (ARN) of the task
execution role that grants the Amazon ECS container agent permission to
make AWS API calls on your behalf. The task execution IAM role is
required depending on the requirements of your task. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html}{Amazon ECS task execution IAM role}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}

\section{networkMode}{


The Docker networking mode to use for the containers in the task. The
valid values are \code{none}, \code{bridge}, \code{awsvpc}, and \code{host}. If no network
mode is specified, the default is \code{bridge}.

For Amazon ECS tasks on Fargate, the \code{awsvpc} network mode is required.
For Amazon ECS tasks on Amazon EC2 instances, any network mode can be
used. If the network mode is set to \code{none}, you cannot specify port
mappings in your container definitions, and the tasks containers do not
have external connectivity. The \code{host} and \code{awsvpc} network modes offer
the highest networking performance for containers because they use the
EC2 network stack instead of the virtualized network stack provided by
the \code{bridge} mode.

With the \code{host} and \code{awsvpc} network modes, exposed container ports are
mapped directly to the corresponding host port (for the \code{host} network
mode) or the attached elastic network interface port (for the \code{awsvpc}
network mode), so you cannot take advantage of dynamic host port
mappings.

When using the \code{host} network mode, you should not run containers using
the root user (UID 0). It is considered best practice to use a non-root
user.

If the network mode is \code{awsvpc}, the task is allocated an elastic
network interface, and you must specify a NetworkConfiguration value
when you create a service or run a task with the task definition. For
more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html}{Task Networking}
in the \emph{Amazon Elastic Container Service Developer Guide}.

Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants
with the \code{ecs-init} package, or AWS Fargate infrastructure support the
\code{awsvpc} network mode.

If the network mode is \code{host}, you cannot run multiple instantiations of
the same task on a single container instance when port mappings are
used.

Docker for Windows uses different network modes than Docker for Linux.
When you register a task definition with Windows containers, you must
not specify a network mode. If you use the console to register a task
definition with Windows containers, you must choose the ``
network mode object.

For more information, see \href{https://docs.docker.com/engine/reference/run/#network-settings}{Network settings}
in the \emph{Docker run reference}.
}

\section{containerDefinitions}{

A list of container definitions in JSON format that
describe the different containers that make up your
task.
}

\section{volumes}{

A list of volume definitions in JSON format
that containers in your task may use.
}

\section{placementConstraints}{

An array of
placement constraint objects to use for the task. You can specify a
maximum of 10 constraints per task (this limit includes constraints in
the task definition and those specified at
runtime).
}

\section{requiresCompatibilities}{

The task launch type that Amazon ECS
should validate the task definition against. This ensures that the task
definition parameters are compatible with the specified launch type. If
no value is specified, it defaults to \code{EC2}.
}

\section{cpu}{


The number of CPU units used by the task. It can be expressed as an
integer using CPU units, for example \code{1024}, or as a string using vCPUs,
for example \verb{1 vCPU} or \verb{1 vcpu}, in a task definition. String values
are converted to an integer indicating the CPU units when the task
definition is registered.

Task-level CPU and memory parameters are ignored for Windows containers.
We recommend specifying container-level resources for Windows
containers.

If you are using the EC2 launch type, this field is optional. Supported
values are between \code{128} CPU units (\code{0.125} vCPUs) and \code{10240} CPU units
(\code{10} vCPUs).

If you are using the Fargate launch type, this field is required and you
must use one of the following values, which determines your range of
supported values for the \code{memory} parameter:
\itemize{
\item 256 (.25 vCPU) - Available \code{memory} values: 512 (0.5 GB), 1024 (1
GB), 2048 (2 GB)
\item 512 (.5 vCPU) - Available \code{memory} values: 1024 (1 GB), 2048 (2 GB),
3072 (3 GB), 4096 (4 GB)
\item 1024 (1 vCPU) - Available \code{memory} values: 2048 (2 GB), 3072 (3 GB),
4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
\item 2048 (2 vCPU) - Available \code{memory} values: Between 4096 (4 GB) and
16384 (16 GB) in increments of 1024 (1 GB)
\item 4096 (4 vCPU) - Available \code{memory} values: Between 8192 (8 GB) and
30720 (30 GB) in increments of 1024 (1 GB)
}
}

\section{memory}{


The amount of memory (in MiB) used by the task. It can be expressed as
an integer using MiB, for example \code{1024}, or as a string using GB, for
example \verb{1GB} or \verb{1 GB}, in a task definition. String values are
converted to an integer indicating the MiB when the task definition is
registered.

Task-level CPU and memory parameters are ignored for Windows containers.
We recommend specifying container-level resources for Windows
containers.

If using the EC2 launch type, this field is optional.

If using the Fargate launch type, this field is required and you must
use one of the following values, which determines your range of
supported values for the \code{cpu} parameter:
\itemize{
\item 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available \code{cpu} values: 256
(.25 vCPU)
\item 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available \code{cpu}
values: 512 (.5 vCPU)
\item 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB),
7168 (7 GB), 8192 (8 GB) - Available \code{cpu} values: 1024 (1 vCPU)
\item Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
Available \code{cpu} values: 2048 (2 vCPU)
\item Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
Available \code{cpu} values: 4096 (4 vCPU)
}
}

\section{tags}{


The metadata that you apply to the task definition to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for AWS
use. You cannot edit or delete tag keys or values with this prefix.
Tags with this prefix do not count against your tags per resource
limit.
}
}

\section{pidMode}{


The process namespace to use for the containers in the task. The valid
values are \code{host} or \code{task}. If \code{host} is specified, then all containers
within the tasks that specified the \code{host} PID mode on the same
container instance share the same process namespace with the host Amazon
EC2 instance. If \code{task} is specified, all containers within the
specified task share the same process namespace. If no value is
specified, the default is a private namespace. For more information, see
\href{https://docs.docker.com/engine/reference/run/#pid-settings---pid}{PID settings}
in the \emph{Docker run reference}.

If the \code{host} PID mode is used, be aware that there is a heightened risk
of undesired process namespace expose. For more information, see \href{https://docs.docker.com/engine/security/security/}{Docker security}.

This parameter is not supported for Windows containers or tasks using
the Fargate launch type.
}

\section{ipcMode}{


The IPC resource namespace to use for the containers in the task. The
valid values are \code{host}, \code{task}, or \code{none}. If \code{host} is specified, then
all containers within the tasks that specified the \code{host} IPC mode on
the same container instance share the same IPC resources with the host
Amazon EC2 instance. If \code{task} is specified, all containers within the
specified task share the same IPC resources. If \code{none} is specified,
then IPC resources within the containers of a task are private and not
shared with other containers in a task or on the container instance. If
no value is specified, then the IPC resource namespace sharing depends
on the Docker daemon setting on the container instance. For more
information, see \href{https://docs.docker.com/engine/reference/run/#ipc-settings---ipc}{IPC settings}
in the \emph{Docker run reference}.

If the \code{host} IPC mode is used, be aware that there is a heightened risk
of undesired IPC namespace expose. For more information, see \href{https://docs.docker.com/engine/security/security/}{Docker security}.

If you are setting namespaced kernel parameters using \code{systemControls}
for the containers in the task, the following will apply to your IPC
resource namespace. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html}{System Controls}
in the \emph{Amazon Elastic Container Service Developer Guide}.
\itemize{
\item For tasks that use the \code{host} IPC mode, IPC namespace related
\code{systemControls} are not supported.
\item For tasks that use the \code{task} IPC mode, IPC namespace related
\code{systemControls} will apply to all containers within a task.
}

This parameter is not supported for Windows containers or tasks using
the Fargate launch type.
}

\section{proxyConfiguration}{

No description can be found.
}

\section{inferenceAccelerators}{

The Elastic Inference
accelerators to use for the containers in the task.
}

