% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesize.R
\name{get_synthesis}
\alias{get_synthesis}
\alias{synthesize}
\title{Synthesize Speech}
\usage{
get_synthesis(text, voice, format = c("mp3", "ogg_vorbis", "pcm"),
  rate = c(22050, 16000, 8000), lexicon = NULL, ssml = FALSE, ...)

synthesize(text, voice, ...)
}
\arguments{
\item{text}{Either a plain text character string or a character string containing SSML (\code{ssml} should be set to \code{TRUE}).}

\item{voice}{A character string specifying the name of an AWS Polly voice. See \code{\link{list_voices}}.}

\item{format}{A character string specifying an output file format.}

\item{rate}{An integer value specifying the audio frequency in Hertz.}

\item{lexicon}{Optionally, a character vector (max length 5) specifying the names of lexicons to apply during synthesis. See \code{\link{get_lexicon}}.}

\item{ssml}{A logical indicating whether \code{text} contains SSML markup.}

\item{\dots}{Additional arguments passed to \code{\link{pollyHTTP}}.}
}
\value{
\code{get_synthesis} returns a raw vector (i.e., the bytes representing the audio as the requested file format). \code{synthesize} is a convenience wrapper around that, which returns an object of class \dQuote{Wave} (see \code{\link[tuneR]{Wave}}).
}
\description{
Pass text to the synthesis API and return an audio file
}
\examples{
\dontrun{
hello <- synthesize("hello world!", voice = "Geraint")
if (interactive() & require("tuneR")) {
    try(play(hello))
}
}
}

