% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head_object.R
\name{head_object}
\alias{head_object}
\alias{object_exists}
\alias{object_size}
\title{Get object metadata}
\usage{
head_object(object, bucket, ...)

object_exists(object, bucket, ...)

object_size(object, bucket, ...)
}
\arguments{
\item{object}{Character string with the object key, or an object of class \dQuote{s3_object}. In most cases, if \code{object} is specified as the latter, \code{bucket} can be omitted because the bucket name will be extracted from \dQuote{Bucket} slot in \code{object}.}

\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
\code{head_object} returns a logical. \code{object_exists} returns \code{TRUE} if bucket exists and is accessible, else \code{FALSE}. \code{object_size} returns an integer, which is \code{NA} if the request fails.
}
\description{
Check if an object from an S3 bucket exists. To retrieve the object, see \code{\link{get_object}}
}
\details{
\code{head_object} is a low-level API wrapper that checks whether an object exists by executing an HTTP HEAD request; this can be useful for checking object headers such as \dQuote{content-length} or \dQuote{content-type}. \code{object_exists} is sugar that returns only the logical.

\code{object_size} returns the size of the object (from the \dQuote{content-length} attribute returned by \code{head_object}).
}
\examples{
\dontrun{
  # get an object in memory
  ## create bucket
  b <- put_bucket("myexamplebucket")
  
  ## save a dataset to the bucket
  s3save(mtcars, bucket = b, object = "mtcars")
  
  # check that object exists
  object_exists("mtcars", "myexamplebucket")
  object_exists("s3://myexamplebucket/mtcars")
  
  # get the object's size
  object_size("s3://myexamplebucket/mtcars")
  
  # get the object
  get_object("s3://myexamplebucket/mtcars")
}
}
\references{
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html}{API Documentation: HEAD Object}
}
\seealso{
\code{\link{bucket_exists}}, \code{\link{get_object}}, \code{\link{put_object}}, \code{\link{delete_object}}
}
