% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{modelUnitConversion}
\alias{modelUnitConversion}
\title{Unit conversion for pharmacokinetic models}
\usage{
modelUnitConversion(
  dvu = NA_character_,
  amtu = NA_character_,
  timeu = NA_character_,
  volumeu = NA_character_
)
}
\arguments{
\item{dvu, amtu, timeu}{The units for the DV, AMT, and TIME columns in the data}

\item{volumeu}{The units for the volume parameters in the model}
}
\value{
A list with names for the units associated with each parameter
("amtu", "clearanceu", "volumeu", "timeu", "dvu") and the numeric value to
multiply the modeled estimate (for example, \code{cp}) so that the model is
consistent with the data units.
}
\description{
Unit conversion for pharmacokinetic models
}
\examples{
modelUnitConversion(dvu = "ng/mL", amtu = "mg", timeu = "hr", volumeu = "L")
}
\seealso{
Other Unit conversion: 
\code{\link{simplifyUnit}()}
}
\concept{Unit conversion}
