% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.helpers.R
\name{bipartite.null}
\alias{bipartite.null}
\title{bipartite.null: generates a backbone object from a bipartite matrix using a null model defined by constraining row and/or column sums.}
\usage{
bipartite.null(
  B,
  rows = TRUE,
  cols = TRUE,
  trials = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{B}{graph: Bipartite graph object of class matrix, sparse matrix, igraph, edgelist, or network object.}

\item{rows}{boolean: TRUE if the row sums should be constrained by the null model, FALSE if not.}

\item{cols}{boolean: TRUE if the column sums should be constrained by the null model, FALSE if not.}

\item{trials}{integer: number of monte carlo trials used to estimate the \link{fdsm} null model (rows = TRUE, cols = TRUE)}

\item{progress}{Boolean: If \link[utils]{txtProgressBar} should be used to measure progress}

\item{...}{optional arguments}
}
\value{
backbone, a list(positive, negative, summary). Here
    `positive` is a matrix of probabilities of edge weights being equal to or above the observed value in the projection,
    `negative` is a matrix of probabilities of edge weights being equal to or below the observed value in the projection, and
    `summary` is a data frame summary of the inputted matrix and the model used including: model name, number of rows, skew of row sums, number of columns, skew of column sums, and running time.
}
\description{
bipartite.null: generates a backbone object from a bipartite matrix using a null model defined by constraining row and/or column sums.
}
\details{
When only rows are constrained, the hypergeometric null model (\link{hyperg}) is used.
    When rows and columns are constrained, the stochastic degree sequence model (\link{sdsm}) is used.
    When rows and columns are constrained and trials are specified, the fixed degree sequence model (\link{fdsm}) is used.
}
\examples{
bipartite.null(davis, rows = TRUE, cols = FALSE) #runs hyperg on davis data
}
