% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify.R
\name{sparsify.with.meetmin}
\alias{sparsify.with.meetmin}
\title{Extract Goldberg and Roth's (2003) MeetMin backbone}
\usage{
sparsify.with.meetmin(U, s, class = "original", narrative = FALSE)
}
\arguments{
\item{U}{An unweighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix, sparse \code{\link{Matrix}}, or dataframe; (2) an edgelist in the form of a two-column matrix, sparse \code{\link{Matrix}}, or dataframe; (3) an \code{\link{igraph}} object; (4) a \code{\link{network}} object.}

\item{s}{numeric: Sparsificiation threshold, 0 < s < 1; larger values yield sparser graphs}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "sparseMatrix", "igraph", "network", "edgelist").
If "original", the backbone graph returned is of the same class as \code{U}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An unweighted, undirected, unipartite graph of class \code{class}.
}
\description{
\code{sparsify.with.meetmin} is a wrapper for \code{\link[=sparsify]{sparsify()}} that extracts the meetmin backbone described by Goldberg and Roth (2003).
It is equivalent to \code{sparsify(escore = "meetmin", normalize = "none", filter = "threshold", umst = FALSE)}.
}
\examples{
U <- igraph::sbm.game(60, matrix(c(.75,.25,.25,.25,.75,.25,.25,.25,.75),3,3), c(20,20,20))
plot(U) #A hairball
sparse <- sparsify.with.meetmin(U, s = 0.5, narrative = TRUE)
plot(sparse) #Clearly visible communities
}
\references{
{Goldberg, D. S., & Roth, F. P. (2003). Assessing experimentally derived interactions in a small world. \emph{Proceedings of the National Academy of Sciences, 100}, 4372-4376. \doi{10.1073/pnas.0735871100}}
}
