% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{RW}
\alias{RW}
\title{Random Walk Prior}
\usage{
RW(s = 1, along = NULL)
}
\arguments{
\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{along}{Name of the variable to be used
as the "along" variable. Only used with
interactions.}
}
\value{
An object of class \code{"bage_prior_rw"}.
}
\description{
Use a random walk to model
a main effect, or use multiple random walks
to model an interaction.
Typically used with age or time effects or with
interactions that involve age or time.
}
\details{
If \code{RW()} is used with an interaction,
separate random walks are constructed along
the "along" variable, within each combination of the
"by" variables.

Argument \code{s} controls the size of innovations.
Smaller values for \code{s} tend to give smoother series.
}
\section{Mathematical details}{


When \code{RW()} is used with a main effect,

\deqn{\beta_j = \beta_{j-1} + \epsilon_j}
\deqn{\epsilon_j \sim \text{N}(0, \tau^2),}

and when it is used with an interaction,

\deqn{\beta_{u,v} = \beta_{u,v-1} + \epsilon_{u,v}}
\deqn{\epsilon_{u,v} \sim \text{N}(0, \tau^2),}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the "along" variable of the interaction; and
\item \eqn{u} denotes position within the "by" variable(s) of the interaction.
}

Parameter \eqn{\tau}
has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \text{s}^2),}
where \code{s} is provided by the user.
}

\examples{
RW()
RW(s = 0.5)
RW(along = "cohort")
}
\seealso{
\itemize{
\item \code{\link[=RW2]{RW2()}} Second-order random walk
\item \code{\link[=AR]{AR()}} Autoregressive with order k
\item \code{\link[=AR1]{AR1()}} Autoregressive with order 1
\item \code{\link[=Sp]{Sp()}} Smoothing via splines
\item \code{\link[=SVD]{SVD()}} Smoothing of age via singular value decomposition
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
}
}
