% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_quantiles.R
\name{plot_quantiles}
\alias{plot_quantiles}
\title{plot quantiles}
\usage{
plot_quantiles(fit, ncol, hline = TRUE)
}
\arguments{
\item{fit}{an object of class \code{baggr}}

\item{ncol}{number of columns for the plot; defaults to half of number of groups}

\item{hline}{logical; plots a line through 0}
}
\value{
ggplot2 object
}
\description{
Plot results for baggr quantile models. Displays results facetted per group.
Results are \code{ggplot2} plots and can be modified.
}
\examples{
\dontrun{
bg <- baggr(microcredit_simplified, model = "quantiles",
            quantiles = c(0.25, 0.50, 0.75),
            iter = 1000, refresh = 0,
            outcome = "consumption")
#vanilla plot
plot_quantiles(bg)[[1]]
plot_quantiles(bg, hline = TRUE)[[2]] +
  ggplot2::coord_cartesian(ylim = c(-2, 5)) +
  ggplot2::ggtitle("Works like a ggplot2 plot!")
}

}
