% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbf.R
\name{pbf}
\alias{pbf}
\alias{pbf.default}
\alias{pbf.numeric}
\title{Product Bayes Factor}
\usage{
pbf(...)

\method{pbf}{default}(x, ...)

\method{pbf}{numeric}(yi, vi, ni, hypothesis = "y = 0", ...)
}
\arguments{
\item{...}{Additional arguments passed to `bain`.}

\item{x}{An object for which a method exists, see Details.}

\item{yi}{Numeric vector with the observed effect sizes.}

\item{vi}{Numeric vector with the observed sampling variances.}

\item{ni}{Integer vector with the sample sizes.}

\item{hypothesis}{A character string containing the informative hypotheses to evaluate.}
}
\value{
A `data.frame` of class `pbf`.
}
\description{
The product Bayes factor (PBF) aggregates evidence for
an informative hypothesis across conceptual replication studies
without imposing assumptions about heterogeneity.
}
\details{
Currently, the argument `x` accepts either:
* A list of `bain` objects, resulting from a call to `bain`.
* A list of model objects for which a `bain` method exists;
  in this case, `pbf` will call `bain` on these model objects
  before aggregating the Bayes factors.
}
\examples{
pbf(yi = c(-.33, .32, .39, .31),
    vi = c(.085, .034, .016, .071),
    ni = c(7, 10, 13, 20))
}
\references{
Van Lissa, C. J., Kuiper, R. M., & Clapper, E.
(2023, April 25). Aggregating evidence from conceptual
replication studies using the product Bayes factor.
\doi{10.31234/osf.io/nvqpw}
}
