% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDetectorNames.R
\name{getDetectorNames}
\alias{getDetectorNames}
\title{Detector Names}
\usage{
getDetectorNames(x)
}
\arguments{
\item{x}{a \code{\link{banter_model}} object.}
}
\value{
a vector of names.
}
\description{
Return names of detectors loaded in BANTER model.
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
# add all detector models
bant.mdl <- addBanterDetector(
  bant.mdl, train.data$detectors, 
  ntree = 50, sampsize = 1, num.cores = 1
)
getDetectorNames(bant.mdl)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
