/*
 * Decompiled with CFR 0.152.
 */
package OpenSourceExtensions;

public class StatUtil {
    private static final double P_LOW = 0.02425;
    private static final double P_HIGH = 0.97575;
    private static final double[] ICDF_A = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
    private static final double[] ICDF_B = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
    private static final double[] ICDF_C = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
    private static final double[] ICDF_D = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
    private static final double[] ERF_A = new double[]{3.1611237438705655, 113.86415415105016, 377.485237685302, 3209.3775891384694, 0.18577770618460315};
    private static final double[] ERF_B = new double[]{23.601290952344122, 244.02463793444417, 1282.6165260773723, 2844.236833439171};
    private static final double[] ERF_C = new double[]{0.5641884969886701, 8.883149794388377, 66.11919063714163, 298.6351381974001, 881.952221241769, 1712.0476126340707, 2051.0783778260716, 1230.3393547979972, 2.1531153547440383E-8};
    private static final double[] ERF_D = new double[]{15.744926110709835, 117.6939508913125, 537.1811018620099, 1621.3895745666903, 3290.7992357334597, 4362.619090143247, 3439.3676741437216, 1230.3393548037495};
    private static final double[] ERF_P = new double[]{0.30532663496123236, 0.36034489994980445, 0.12578172611122926, 0.016083785148742275, 6.587491615298378E-4, 0.016315387137302097};
    private static final double[] ERF_Q = new double[]{2.568520192289822, 1.8729528499234604, 0.5279051029514285, 0.06051834131244132, 0.0023352049762686918};
    private static final double PI_SQRT = Math.sqrt(Math.PI);
    private static final double THRESHOLD = 0.46875;
    private static final double X_MIN = Double.MIN_VALUE;
    private static final double X_INF = Double.MAX_VALUE;
    private static final double X_NEG = -9.38241396824444;
    private static final double X_SMALL = (double)1.110223E-16f;
    private static final double X_BIG = 9.194;
    private static final double X_HUGE = 1.0 / (2.0 * Math.sqrt(1.110223E-16f));
    private static final double X_MAX = Math.min(Double.MAX_VALUE, 1.0 / (Math.sqrt(Math.PI) * Double.MIN_VALUE));

    public static double getInvCDF(double d, boolean bl) {
        double d2 = 0.0;
        if (d == 0.0) {
            d2 = Double.NEGATIVE_INFINITY;
        } else if (d == 1.0) {
            d2 = Double.POSITIVE_INFINITY;
        } else if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            d2 = Double.NaN;
        } else if (d < 0.02425) {
            double d3 = Math.sqrt(-2.0 * Math.log(d));
            d2 = (((((ICDF_C[0] * d3 + ICDF_C[1]) * d3 + ICDF_C[2]) * d3 + ICDF_C[3]) * d3 + ICDF_C[4]) * d3 + ICDF_C[5]) / ((((ICDF_D[0] * d3 + ICDF_D[1]) * d3 + ICDF_D[2]) * d3 + ICDF_D[3]) * d3 + 1.0);
        } else if (0.97575 < d) {
            double d4 = Math.sqrt(-2.0 * Math.log(1.0 - d));
            d2 = -(((((ICDF_C[0] * d4 + ICDF_C[1]) * d4 + ICDF_C[2]) * d4 + ICDF_C[3]) * d4 + ICDF_C[4]) * d4 + ICDF_C[5]) / ((((ICDF_D[0] * d4 + ICDF_D[1]) * d4 + ICDF_D[2]) * d4 + ICDF_D[3]) * d4 + 1.0);
        } else {
            double d5 = d - 0.5;
            double d6 = d5 * d5;
            d2 = (((((ICDF_A[0] * d6 + ICDF_A[1]) * d6 + ICDF_A[2]) * d6 + ICDF_A[3]) * d6 + ICDF_A[4]) * d6 + ICDF_A[5]) * d5 / (((((ICDF_B[0] * d6 + ICDF_B[1]) * d6 + ICDF_B[2]) * d6 + ICDF_B[3]) * d6 + ICDF_B[4]) * d6 + 1.0);
        }
        if (bl) {
            d2 = StatUtil.refine(d2, d);
        }
        return d2;
    }

    private static double calerf(double d, int n) {
        double d2;
        double d3 = 0.0;
        double d4 = Math.abs(d);
        if (d4 <= 0.46875) {
            double d5 = 0.0;
            if (d4 > (double)1.110223E-16f) {
                d5 = d4 * d4;
            }
            double d6 = ERF_A[4] * d5;
            double d7 = d5;
            for (int i = 0; i < 3; ++i) {
                d6 = (d6 + ERF_A[i]) * d5;
                d7 = (d7 + ERF_B[i]) * d5;
            }
            d3 = d * (d6 + ERF_A[3]) / (d7 + ERF_B[3]);
            if (n != 0) {
                d3 = 1.0 - d3;
            }
            if (n == 2) {
                d3 = Math.exp(d5) * d3;
            }
            return d3;
        }
        if (d4 <= 4.0) {
            double d8 = ERF_C[8] * d4;
            double d9 = d4;
            for (int i = 0; i < 7; ++i) {
                d8 = (d8 + ERF_C[i]) * d4;
                d9 = (d9 + ERF_D[i]) * d4;
            }
            d3 = (d8 + ERF_C[7]) / (d9 + ERF_D[7]);
            if (n != 2) {
                d2 = (double)Math.round(d4 * 16.0) / 16.0;
                double d10 = (d4 - d2) * (d4 + d2);
                d3 = Math.exp(-d2 * d2) * Math.exp(-d10) * d3;
            }
        } else {
            d3 = 0.0;
            if (!(d4 >= 9.194) || n == 2 && !(d4 >= X_MAX)) {
                if (d4 >= 9.194 && d4 >= X_HUGE) {
                    d3 = PI_SQRT / d4;
                } else {
                    d2 = 1.0 / (d4 * d4);
                    double d11 = ERF_P[5] * d2;
                    double d12 = d2;
                    for (int i = 0; i < 4; ++i) {
                        d11 = (d11 + ERF_P[i]) * d2;
                        d12 = (d12 + ERF_Q[i]) * d2;
                    }
                    d3 = d2 * (d11 + ERF_P[4]) / (d12 + ERF_Q[4]);
                    d3 = (PI_SQRT - d3) / d4;
                    if (n != 2) {
                        d2 = (double)Math.round(d4 * 16.0) / 16.0;
                        double d13 = (d4 - d2) * (d4 + d2);
                        d3 = Math.exp(-d2 * d2) * Math.exp(-d13) * d3;
                    }
                }
            }
        }
        if (n == 0) {
            d3 = 0.5 - d3 + 0.5;
            if (d < 0.0) {
                d3 = -d3;
            }
        } else if (n == 1) {
            if (d < 0.0) {
                d3 = 2.0 - d3;
            }
        } else if (d < 0.0) {
            if (d < -9.38241396824444) {
                d3 = Double.MAX_VALUE;
            } else {
                d2 = (double)Math.round(d * 16.0) / 16.0;
                double d14 = (d - d2) * (d + d2);
                d4 = Math.exp(d2 * d2) * Math.exp(d14);
                d3 = d4 + d4 - d3;
            }
        }
        return d3;
    }

    public static double erf(double d) {
        return StatUtil.calerf(d, 0);
    }

    public static double erfc(double d) {
        return StatUtil.calerf(d, 1);
    }

    public static double erfcx(double d) {
        return StatUtil.calerf(d, 2);
    }

    public static double refine(double d, double d2) {
        if (d2 > 0.0 && d2 < 1.0) {
            double d3 = 0.5 * StatUtil.erfc(-d / Math.sqrt(2.0)) - d2;
            double d4 = d3 * Math.sqrt(Math.PI * 2) * Math.exp(d * d / 2.0);
            d -= d4 / (1.0 + d * d4 / 2.0);
        }
        return d;
    }
}

