/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import CustomLogging.LoggingOutputStream;
import CustomLogging.StdOutErrLevel;
import CustomLogging.SuperSimpleFormatter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.stream.IntStream;

public abstract class Classifier
implements Serializable {
    private static final long serialVersionUID = -7470305759402002995L;
    public static final boolean ON_WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    public static final double MISSING_VALUE = Double.NaN;
    protected transient ArrayList<double[]> X_y;
    protected transient ArrayList<double[]> X_y_by_col;
    protected transient double[] y_orig;
    protected transient double[] y_trans;
    protected int n;
    protected int p;
    protected String unique_name = "unnamed";
    private transient double[] in_sample_residuals;

    public static boolean isMissing(double d) {
        return Double.isNaN(d);
    }

    public void addTrainingDataRow(String[] stringArray) {
        if (this.X_y == null) {
            this.X_y = new ArrayList();
        }
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                dArray[i] = Double.parseDouble(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                dArray[i] = Double.NaN;
            }
        }
        this.X_y.add(dArray);
    }

    public void finalizeTrainingData() {
        this.setData(this.X_y);
    }

    public void setData(ArrayList<double[]> arrayList) {
        this.n = arrayList.size();
        this.p = arrayList.get(0).length - 1;
        this.y_orig = this.extractResponseFromRawData(arrayList);
        this.transformResponseVariable();
        this.X_y = this.addIndicesToDataMatrix(arrayList);
        this.X_y_by_col = this.getDataMatrixByCol(arrayList);
    }

    private ArrayList<double[]> getDataMatrixByCol(ArrayList<double[]> arrayList) {
        double[][] dArray = new double[this.p][this.n];
        IntStream.range(0, this.p).parallel().forEach(n -> {
            for (int i = 0; i < this.n; ++i) {
                dArray[n][i] = ((double[])arrayList.get(i))[n];
            }
        });
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>(this.p);
        for (int i = 0; i < this.p; ++i) {
            arrayList2.add(dArray[i]);
        }
        return arrayList2;
    }

    private ArrayList<double[]> addIndicesToDataMatrix(ArrayList<double[]> arrayList) {
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>(this.n);
        for (int i = 0; i < this.n; ++i) {
            double[] dArray = new double[this.p + 2];
            for (int j = 0; j < this.p + 1; ++j) {
                dArray[j] = arrayList.get(i)[j];
            }
            dArray[this.p + 1] = i;
            arrayList2.add(dArray);
        }
        return arrayList2;
    }

    private double[] extractResponseFromRawData(ArrayList<double[]> arrayList) {
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            double[] dArray2 = arrayList.get(i);
            dArray[i] = dArray2[dArray2.length - 1];
        }
        return dArray;
    }

    public abstract void Build();

    public void suppressOrWriteToDebugLog() {
        LogManager logManager = LogManager.getLogManager();
        logManager.reset();
        Handler handler = null;
        try {
            handler = new FileHandler(this.unique_name + ".log", Integer.MAX_VALUE, 1, false);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        handler.setFormatter(new SuperSimpleFormatter());
        Logger.getLogger("").addHandler(handler);
        Logger logger = Logger.getLogger("stdout");
        LoggingOutputStream loggingOutputStream = new LoggingOutputStream(logger, StdOutErrLevel.STDOUT);
        System.setOut(new PrintStream(loggingOutputStream, true));
        logger = Logger.getLogger("stderr");
        loggingOutputStream = new LoggingOutputStream(logger, StdOutErrLevel.STDERR);
        System.setErr(new PrintStream(loggingOutputStream, true));
    }

    protected abstract void FlushData();

    public abstract double Evaluate(double[] var1, int var2);

    public double[] Evaluate(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.Evaluate(dArray[i], n);
        }
        return dArray2;
    }

    public double Evaluate(double[] dArray) {
        return this.Evaluate(dArray, 1);
    }

    public double getResponseFromRecord(double[] dArray) {
        return dArray[this.p];
    }

    public abstract void StopBuilding();

    public int getP() {
        return this.p;
    }

    public int getN() {
        return this.n;
    }

    public void dumpDataToFile(String string) {
        int n;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter("data_out" + (string == null ? "" : string) + ".csv")));
        }
        catch (IOException iOException) {
            System.out.println("cannot be edited in CSV appending");
        }
        for (n = 0; n < this.p; ++n) {
            printWriter.print("," + n);
        }
        printWriter.print(",y");
        printWriter.print("\n");
        for (n = 0; n < this.n; ++n) {
            double[] dArray = this.X_y.get(n);
            for (int i = 0; i <= this.p; ++i) {
                printWriter.print("," + dArray[i]);
            }
            printWriter.print("\n");
        }
        printWriter.close();
    }

    private void calculateInSampleResiduals(int n) {
        long l = System.currentTimeMillis();
        System.out.print("calculating in-sample residuals...");
        this.in_sample_residuals = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            double[] dArray = this.X_y.get(i);
            double d = this.getResponseFromRecord(dArray);
            double d2 = this.Evaluate(dArray, n);
            this.in_sample_residuals[i] = d - d2;
        }
        long l2 = System.currentTimeMillis();
        System.out.print("done in " + (double)(l2 - l) / 1000.0 + " sec \n");
    }

    public double calculateInSampleLoss(ErrorTypes errorTypes, int n) {
        if (this.in_sample_residuals == null) {
            this.calculateInSampleResiduals(n);
        }
        double d = 0.0;
        System.out.print("calculateInSampleLoss for " + String.valueOf((Object)errorTypes) + "...");
        block5: for (int i = 0; i < this.n; ++i) {
            switch (errorTypes.ordinal()) {
                case 0: {
                    d += Math.abs(this.in_sample_residuals[i]);
                    continue block5;
                }
                case 1: {
                    d += this.in_sample_residuals[i] * this.in_sample_residuals[i];
                    continue block5;
                }
                case 2: {
                    d += (double)(this.in_sample_residuals[i] != 0.0 ? 1 : 0);
                }
            }
        }
        System.out.print("done\n");
        return d;
    }

    protected void transformResponseVariable() {
        this.y_trans = new double[this.y_orig.length];
        for (int i = 0; i < this.n; ++i) {
            this.y_trans[i] = this.y_orig[i];
        }
    }

    protected double un_transform_y(double d) {
        return d;
    }

    public Classifier clone() {
        return null;
    }

    public void setUniqueName(String string) {
        this.unique_name = string;
    }

    public void writeStdOutToLogFile() {
        try {
            Logger.getLogger("").addHandler(new StreamHandler());
            this.suppressOrWriteToDebugLog();
        }
        catch (Error error) {
            System.out.println("Logger and or suppressOrWriteToDebugLog FAILING\n");
        }
    }

    public static enum ErrorTypes {
        L1,
        L2,
        MISCLASSIFICATION;

    }
}

