% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_plot.R
\name{decision_plot}
\alias{decision_plot}
\title{Decision plot}
\usage{
decision_plot(
  object,
  obs_num,
  title = NULL,
  geo.unit = NULL,
  geo.id = NULL,
  bar_default = TRUE
)
}
\arguments{
\item{object}{Enter the name of the object that contains the model's contributions
and results obtained using the Explain function.}

\item{obs_num}{single or multiple observation numbers}

\item{title}{plot title}

\item{geo.unit}{The name of the stratum variable in the BARP model as a character.}

\item{geo.id}{Enter a single value of the stratum variable as a character.}

\item{bar_default}{\code{bar_default} is an option for adjusting the legend's color scale to fit the window length, and its default value is set to \code{TRUE}. 
If plots fail to render in LaTeX documents, it is recommended to set this option to \code{FALSE}.}
}
\value{
\item{plot_out}{The decision plot for one or multiple observations specified in \code{obs_num}.}
}
\description{
The \code{decision_plot} function is a graph that visualizes how individual features
contribute to a model's prediction for a specific observation using Shapley values.
 It can be used to visualize one or multiple observations.
}
\examples{
\donttest{
## Friedman data
set.seed(2025)
n = 200
p = 5
X = data.frame(matrix(runif(n * p), ncol = p))
y = 10 * sin(pi* X[ ,1] * X[,2]) +20 * (X[,3] -.5)^2 + 10 * X[ ,4] + 5 * X[,5] + rnorm(n)

## BART model
model = dbarts::bart (X,y, keeptrees = TRUE,ndpost = 200 )

# prediction wrapper function
pfun <- function (object, newdata) {
predict(object, newdata)
}

# Calculate shapley values
model_exp =  Explain  ( model, X = X,  pred_wrapper =  pfun )

# Single observation 
decision_plot(model_exp, obs_num=1 )

#Multiple observation 
decision_plot(model_exp, obs_num=10:40 )
}
}
