% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sptrc_team_active_payroll.R
\name{sptrc_team_active_payroll}
\alias{sptrc_team_active_payroll}
\title{\strong{Scrape Team Active Payroll Breakdown from Spotrac}}
\usage{
sptrc_team_active_payroll(team_abbr, year = most_recent_mlb_season())
}
\arguments{
\item{team_abbr}{Team abbreviation}

\item{year}{Year to load}
}
\value{
A data frame of contract data.\tabular{ll}{
   col_name \tab types \cr
   year \tab numeric \cr
   team \tab character \cr
   player_name \tab character \cr
   roster_status \tab character \cr
   age \tab numeric \cr
   pos \tab numeric \cr
   status \tab numeric \cr
   waiver_options \tab numeric \cr
   base_salary \tab numeric \cr
   signing_bonus \tab numeric \cr
   payroll_salary \tab numeric \cr
   adj_salary \tab numeric \cr
   payroll_percent \tab numeric \cr
   lux_tax_salary \tab numeric \cr
   total_salary \tab numeric \cr
}
}
\description{
This function allows you to scrape a team's active payroll from Spotrac.
}
\examples{
\donttest{
  try(sptrc_team_active_payroll(team_abbr = "BAL", year = most_recent_mlb_season()))
}
}
