% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_dummy_classifier.R
\name{predict_dummy_classifier}
\alias{predict_dummy_classifier}
\title{dummy classifier predictor}
\usage{
predict_dummy_classifier(object, X)
}
\arguments{
\item{object}{a list created using dummy classifier.}

\item{X}{a data frame.}
}
\value{
predicted values for the response variable.
}
\description{
dummy classifier predictor
}
\examples{
# Split the data into training and testing sets
set.seed(2023)
index <- sample(1:nrow(iris), nrow(iris) * 0.8)
train_data <- iris[index,]
test_data <- iris[-index,]
dummy_model <- dummy_classifier(train_data$Species, strategy = "proportional", random_state = 2024)

# Make predictions using the trained dummy classifier
pred_vec <- predict_dummy_classifier(dummy_model, test_data)

# Evaluate the performance of the dummy classifier
conf_matrix <- caret::confusionMatrix(pred_vec, test_data$Species)
print(conf_matrix)
}
