% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/basket_test.R
\name{basket_test}
\alias{basket_test}
\alias{basket_test,OneStageBasket-method}
\title{Test for the Results of a Basket Trial}
\usage{
basket_test(design, n, r, lambda, epsilon, tau, logbase = 2, prune, ...)

\S4method{basket_test}{OneStageBasket}(design, n, r, lambda, epsilon, tau, logbase = 2, prune, ...)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupBasket}.}

\item{n}{The sample size per basket.}

\item{r}{The vector of observed responses.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{epsilon}{A tuning parameter that determines the amount of borrowing.
See details for more information.}

\item{tau}{A tuning parameter that determines how similar the baskets
have to be that borrowing occurs. See details for more information.}

\item{logbase}{A tuning parameter that determines which logarithm base is
used to compute the Jensen-Shannon divergence. See details for more
information.}

\item{prune}{Whether baskets with a number of responses below the
critical pooled value should be pruned before the final analysis.}

\item{...}{Further arguments.}
}
\value{
A list, including matrices of the weights that are used for
borrowing, posterior distribution parameters for all baskets without and
with borrowing, as well as the posterior probabilities for all baskets
without and with borrowing.
}
\description{
\code{basket_test} evaluates the results of a basket trial and calculates
the posterior distributions with and without borrowing.
}
\section{Methods (by class)}{
\itemize{
\item \code{OneStageBasket}: Testing for a single-stage basket design.
}}

\examples{
design <- setupOneStageBasket(k = 3, shape1 = 1, shape2 = 1, theta0 = 0.2)
basket_test(design = design, n = 24, r = c(5, 9, 10), lambda = 0.99,
  epsilon = 1, tau = 0, logbase = 2, prune = FALSE)
}
