% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalweights.R
\name{globalweights_diff}
\alias{globalweights_diff}
\title{Global Weights Based on Response Rate Differences}
\usage{
globalweights_diff(n, r, eps_global = 1, w = 1)
}
\arguments{
\item{n}{The sample size per basket.}

\item{r}{Vector of responses.}

\item{eps_global}{A tuning parameter that determines the amount of borrowing.
A higher value leads to a smaller weight and therefore less borrowing
when the heterogeneity between the results in the baskets increases.}

\item{w}{A fixed probability between 0 and 1. \code{w} is multiplied to
the weight.}
}
\value{
A numeric value.
}
\description{
Global Weights Based on Response Rate Differences
}
\details{
\code{globalweights_diff} calculates a weight based on the
heterogeneity of the response rates of all baskets that is multiplied
to the pairwise weights calculated with the function that is passed to
\code{weight_fun}. The weight is 1 when the number of responses is identical
in all baskets and 0 if the response rates are an equidistant sequence
from 0 to 1. If the maximum weight should be smaller than 1, \code{w}
can  be set to a smaller value.
}
\examples{
globalweights_diff(n = 20, r = c(1, 3, 5), eps_global = 2)
}
