% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_details.R
\name{get_details.cpp}
\alias{get_details.cpp}
\title{Get Details of a Basket Trial Simulation with the Calibrated Power Prior
Design}
\usage{
\method{get_details}{cpp}(
  design,
  n,
  p1 = NULL,
  lambda,
  level = 0.95,
  tune_a,
  tune_b,
  iter = 1000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object of class \code{cpp}.}

\item{n}{The sample size per basket.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{tune_a}{First tuning parameter that determines the amount of borrowing
based on pairwise similarity between baskets.}

\item{tune_b}{Second tuning parameter that determines the amount of borrowing
based on pairwise similarity between baskets.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A list containing the rejection probabilites, posterior means,
mean squared errors and mean limits of HDI intervals for all baskets as well
as the family-wise error rate.
}
\description{
Get Details of a Basket Trial Simulation with the Calibrated Power Prior
Design
}
\examples{
design <- setup_cpp(k = 3, p0 = 0.2)
get_details(design = design, n = 20, p1 = c(0.2, 0.5, 0.5), lambda = 0.95,
  tune_a = 1, tune_b = 1, iter = 100)
}
