% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateGroupIDsInSimulator.R
\name{generateGroupIDsInSimulator}
\alias{generateGroupIDsInSimulator}
\title{Generate group IDs}
\usage{
generateGroupIDsInSimulator(
  N,
  K,
  B,
  batch_IDs,
  group_weights,
  varying_group_within_batch
)
}
\arguments{
\item{N}{The number of items (rows) to generate.}

\item{K}{The number of groups to genetare.}

\item{B}{The number of batches present in ``batch_IDs``.}

\item{batch_IDs}{The batch membership of each item.}

\item{group_weights}{One of either a K x B matrix of the expected proportion
of each batch in each group or a K-vector of the expected proportion of the
entire dataset in each group.}

\item{varying_group_within_batch}{Flag indicating if the groups are vvarying
across batches.}
}
\value{
A N-vector of group membership.
}
\description{
Generate group IDs within ``generateBatchData``.
}
\examples{
N <- 500
K <- 2
B <- 5
group_weights <- rep(1 / K, K)
batch_weights <- rep(1 / B, B)
batch_IDs <- sample(seq(1, B), N, replace = TRUE, prob = batch_weights)
varying_group_within_batch <- FALSE
group_IDs <- generateGroupIDsInSimulator(
  N,
  K,
  B,
  batch_IDs,
  group_weights,
  varying_group_within_batch
)
}
