% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{historical_normal}
\alias{historical_normal}
\title{Historical data for normal distribution}
\usage{
historical_normal(mu0_treatment = NULL, sd0_treatment = NULL,
  N0_treatment = NULL, mu0_control = NULL, sd0_control = NULL,
  N0_control = NULL, discount_function = "identity", alpha_max = 1,
  fix_alpha = FALSE, weibull_scale = 0.135, weibull_shape = 3,
  .data = NULL)
}
\arguments{
\item{mu0_treatment}{numeric. Mean of the historical treatment group.}

\item{sd0_treatment}{numeric. The  Standard deviation of the historical treatment group.}

\item{N0_treatment}{numeric. scalar. Number of observations of the historical treatment group.}

\item{mu0_control}{numeric. Mean of the historical control group.}

\item{sd0_control}{numeric. The  Standard deviation of the historical control group.}

\item{N0_control}{numeric. umber of observations of the historical control group.}

\item{discount_function}{character. Specify the discount function to use. Currently supports
weibull, scaledweibull, and identity. The discount function scaledweibull scales the
output of the Weibull CDF to have a max value of 1. The identity discount function
uses the posterior probability directly as the discount weight. Default value is
"identity".}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{fix_alpha}{logical. Fix alpha at alpha_max? Default value is FALSE.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. For a two-arm trial, users may specify a vector of two
values where the first value is used to estimate the weight of the
historical treatment group and the second value is used to estimate the
weight of the historical control group. Not used when discount_function =
"identity".}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group. Not used when discount_function = "identity".}

\item{.data}{NULL. stores the proportion of control and treatment, please do not fill it in.}
}
\value{
a list with historical data for control and treatment group with the discount function.
}
\description{
Wrapper function for historical data from normal outcome.
}
\examples{
historical_normal(mu0_treatment = 15, sd0_treatment = 2, N0_treatment = 10,
                            mu0_control = 17, sd0_control = 3, N0_control = 20)
}
