% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{normalBACT}
\alias{normalBACT}
\title{Normal distribution for Bayesian Adaptive Trials}
\usage{
normalBACT(mu_treatment, sd_treatment, mu_control = NULL,
  sd_control = NULL, mu0_treatment = NULL, sd0_treatment = NULL,
  N0_treatment = NULL, mu0_control = NULL, sd0_control = NULL,
  N0_control = NULL, N_total, lambda = 0.3, lambda_time = NULL,
  interim_look = NULL, EndofStudy, block = 2, rand_ratio = c(1, 1),
  discount_function = "identity", alternative = "greater",
  prop_loss_to_followup = 0.15, h0 = 0, futility_prob = 0.05,
  expected_success_prob = 0.9, prob_ha = 0.95, N_impute = 10,
  number_mcmc = 10000, alpha_max = 1, fix_alpha = FALSE,
  weibull_scale = 0.135, weibull_shape = 3)
}
\arguments{
\item{mu_treatment}{scalar. Mean outcome in the treatment arm.}

\item{sd_treatment}{scalar. Standard deviation of outcome in the treatment}

\item{mu_control}{scalar. Mean outcome in the control arm.}

\item{sd_control}{scalar. Standard deviation of outcome in the control arm.
arm.}

\item{mu0_treatment}{scalar. Mean of the historical treatment group.}

\item{sd0_treatment}{scalar. Standard deviation of the historical treatment group.}

\item{N0_treatment}{scalar. Number of observations of the historical treatment group.}

\item{mu0_control}{scalar. Mean of the historical control group.}

\item{sd0_control}{scalar. Standard deviation of the historical control group.}

\item{N0_control}{scalar. Number of observations of the historical control group.}

\item{N_total}{scalar. Total sample size.}

\item{lambda}{vector. Erollment rates across simulated enrollment times. See
\code{\link{enrollment}} for more details.}

\item{lambda_time}{vector. Enrollment time(s) at which the enrollment rates
change. Must be same length as lambda. See \code{\link{enrollment}} for
more details.}

\item{interim_look}{vector. Sample size for each interim look. Note: the
maximum sample size should not be included.}

\item{EndofStudy}{scalar. Length of the study.}

\item{block}{scalar. Block size for generating the randomization schedule.}

\item{rand_ratio}{vector. Randomization allocation for the ratio of control
to treatment. Integer values mapping the size of the block. See
\code{\link{randomization}} for more details.}

\item{discount_function}{character. If incorporating historical data, specify
the discount function. Currently supports the Weibull function
(\code{discount_function="weibull"}), the scaled-Weibull function
(\code{discount_function="scaledweibull"}), and the identity function
(\code{discount_function="identity"}). The scaled-Weibull discount function
scales the output of the Weibull CDF to have a max value of 1. The identity
discount function uses the posterior probability directly as the discount
weight. Default value is \code{"identity"}. See \code{\link{bdpnormal}} for
more details.}

\item{alternative}{character. The string specifying the alternative
hypothesis, must be one of \code{"greater"} (default), \code{"less"} or
\code{"two.sided"}.}

\item{prop_loss_to_followup}{scalar. Overall oroportion of subjects lost to
follow-up.}

\item{h0}{scalar. Threshold for comparing two mean values. Default is
\code{h0=0}.}

\item{futility_prob}{scalar. Probability of stopping early for futility.}

\item{expected_success_prob}{scalar. Probability of stopping early for success.}

\item{prob_ha}{scalar. Probability of alternative hypothesis.}

\item{N_impute}{scalar. Number of imputations for Monte Carlo simulation of
missing data.}

\item{number_mcmc}{scalar. Number of Monte Carlo Markov Chain draws in
sampling posterior.}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{fix_alpha}{logical. Fix alpha at alpha_max? Default value is FALSE.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. For a two-arm trial, users may specify a vector of two
values where the first value is used to estimate the weight of the
historical treatment group and the second value is used to estimate the
weight of the historical control group. Not used when discount_function =
"identity".}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group. Not used when discount_function = "identity".}
}
\value{
a list of output for a single trial simulation.
\describe{
  \item{\code{mu_treatment}}{
    scalar. The input parameter of mean value of the outcome in the
    treatment group.}
  \item{\code{p_control}}{
    scalar. The input parameter of mean value of the outcome in the
    control group.}
  \item{\code{sd_treatment}}{
    scalar. The input parameter of standard deviation of the outcome
    in the control group.}
  \item{\code{sd_control}}{
    scalar. The input parameter of standard deviation of the outcome
    in the control group.}
  \item{\code{prob_of_accepting_alternative}}{
    scalar. The input parameter of probability threshold of accepting the
    alternative.}
  \item{\code{margin}}{
    scalar. The margin input value of difference between mean estimate of treatment
     and mean estimate of the control.}
  \item{\code{alternative}}{
    character. The input parameter of alternative hypothesis. }
  \item{\code{interim_look}}{
    vector. The sample size for each interim look.}
  \item{\code{N_treatment}}{
    scalar. The number of patients enrolled in the experimental group for
    each simulation.}
  \item{\code{N_control}}{
    scalar. The number of patients enrolled in the control group for
    each simulation.}
  \item{\code{N_enrolled}}{
    vector. The number of patients enrolled in the trial (sum of control
    and experimental group for each simulation. )}
  \item{\code{N_complete}}{
    scalar. The number of patients who completed the trial and had no
    loss to follow-up.}
  \item{\code{post_prob_accept_alternative}}{
    vector. The final probability of accepting the alternative
    hypothesis after the analysis is done.}
  \item{\code{est_final}}{
    scalar. The final estimate of the difference in posterior estimate of
    treatment and posterior estimate of the control group.}
  \item{\code{stop_futility}}{
    scalar. Did the trial stop for futility during imputation of patient
    who had loss to follow up? 1 for yes and 0 for no.}
  \item{\code{stop_expected_success}}{
    scalar. Did the trial stop for early success during imputation of patient
    who had loss to follow up? 1 for yes and 0 for no.}
  \item{\code{est_interim}}{
    scalar. The interim estimate of the difference in posterior estimate of
    treatment and posterior estimate of the control group.}
}
}
\description{
Simulation of normally distributed data for Bayesian adaptive
  trials with various inputs to control for power, sample size, type I error
  rate, etc.
}
\examples{
normalBACT(mu_treatment = 8,
           sd_treatment = 1.2, N_total = 300,
           lambda = c(0.3, 1), lambda_time = c(25),
           interim_look = c(110, 140, 220, 270),
           EndofStudy = 50)

}
