% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{envelope}
\alias{envelope}
\title{Envelope Graph: Residuals vs Half-Normal Values}
\usage{
envelope(x, sim = 1000, conf = 0.95, resid.type = c("",
"quantile", "sweighted","pearson","ordinary"))
}
\arguments{
\item{x}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}

\item{sim}{a positive integer containing the number of simulations of the half-normal distribution.}

\item{conf}{a probability containing the confidence level for the quantiles made under the half-normal samples.}

\item{resid.type}{the residual type that will be used in the graph}
}
\value{
A graph showing the absolute values of the residuals ordered against the quantiles of simulations of the half-normal distribution.
}
\description{
A graph showing the absolute values of the residuals ordered against the quantiles of simulations of the half-normal distribution.
}
\details{
Atkinson (1985) proposed to use quantiles from a simulated population of the halfnormal distribution, this is used because (blablabla read the book, right). From the distribution of the absolute values of the residual in the graph, it is possible to measure the quality of the model estimation.
}
\examples{
data("CarTask", package = "bayesbr")

bbr = bayesbr(probability~task + NFCCscale, iter = 100,
            data=CarTask, mean_betas = c(1, 0.5,1.2),variance_betas=10)

envelope(bbr,sim = 100, conf=0.9, resid.type="quantile")
\donttest{
envelope(bbr,sim = 1000, conf=0.99, resid.type="ordinary")}
}
\references{
Atkinson, A. C. (1985). Plots, transformations, and regression: An introduction to graphical methods of diagnostic regression analysis. \emph{Oxford: Clarendon Press}.
}
\seealso{
\code{\link{residuals.bayesbr}}, \code{\link{loglikPlot}}, \code{\link{bayesbr}}
}
