% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{pairs_predict}
\alias{pairs_predict}
\alias{pairs.bayesianVARs_predict}
\title{Pairwise visualization of out-of-sample posterior predictive
densities.}
\usage{
\method{pairs}{bayesianVARs_predict}(x, vars, ahead, ...)
}
\arguments{
\item{x}{An object of class \code{bayesianVARs_predict} obtained via
\code{\link[=predict.bayesianVARs_bvar]{predict.bayesianVARs_bvar()}}.}

\item{vars}{Integer vector (or coercible to such) indicating which variables
to plot.}

\item{ahead}{Integer vector (or coercible to such) indicating which step
ahead to plot. \code{max(ahead)} must be smaller equal to
\code{dim(x$predictions)[1]}.}

\item{...}{Currently ignored!}
}
\value{
Returns \code{x} invisibly.
}
\description{
Pairwise visualization of out-of-sample posterior predictive
densities.
}
\note{
Note that that \code{bayesianVARs_predict} can also be used withing \code{\link[=plot.bayesianVARs_bvar]{plot.bayesianVARs_bvar()}}.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Simulate from posterior predictive
predictions <- predict(mod, ahead = 1:3)

# Visualize
pairs(predictions, vars = 1:3, ahead = 1:3)
}
\seealso{
Other plotting \code{\link[=plot.bayesianVARs_bvar]{plot.bayesianVARs_bvar()}},
\code{\link[=plot.bayesianVARs_fitted]{plot.bayesianVARs_fitted()}}, \code{\link[=plot.bayesianVARs_predict]{plot.bayesianVARs_predict()}}
\code{\link[=posterior_heatmap]{posterior_heatmap()}}.
}
