% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data.R
\name{check_data}
\alias{check_data}
\title{check_data}
\usage{
check_data(data, x_var, y_var, trials_var, family, model, random_vars = NA)
}
\arguments{
\item{data}{A \code{\link[base]{data.frame}} containing the data to use for
the model.}

\item{x_var}{A \code{\link[base]{character}} indicating the column heading
containing the concentration (x) variable.}

\item{y_var}{A \code{\link[base]{character}} indicating the column heading
containing the response (y) variable.}

\item{trials_var}{The column heading indicating the column for the number
of "trials" for binomial or beta_binomial2 response data.
If not supplied, the model may run but will not be the model you intended!}

\item{family}{Either a \code{\link[base]{character}} string, a function, or
an object of class \code{\link[stats]{family}} defining the statistical
distribution (family) to use for the y (response) data. See details.}

\item{model}{A \code{\link[base]{character}} vector indicating the model(s)
to fit. See Details for more information.}

\item{random_vars}{= A \code{\link[base]{character}} vector containing the names of
the columns containing the variables used in the random model formula.}
}
\value{
A \code{\link[base]{list}} of modified elements
necessary for \code{\link{fit_bayesnec}}.
}
\description{
Check data input for a Bayesian NEC model fit
}
\details{
This is a wrapper function to test input data criteria and find the
correct priors for use in \code{\link{fit_bayesnec}}.
}
