% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_fitted.R
\name{compare_fitted}
\alias{compare_fitted}
\title{compare_fitted}
\usage{
compare_fitted(x, precision = 50, x_range = NA)
}
\arguments{
\item{x}{A named \code{\link[base]{list}} of objects of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} returned by
\code{\link{bnec}}.}

\item{precision}{The number of unique x values over which to find ECx -
large values will make the ECx estimate more precise.}

\item{x_range}{A range of x values over which to consider extracting ECx.}
}
\value{
A named \code{\link[base]{list}} containing bootstrapped differences
in posterior predictions of the \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}} model fits contained in \code{x}. See Details.
}
\description{
Extracts posterior predicted values from a list of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} model fits and
compares these across a vector of fitted values.
}
\examples{
\dontrun{
library(bayesnec)
data(manec_example)
nec4param <- pull_out(manec_example, model = "nec4param")
ecx4param <- pull_out(manec_example, model = "ecx4param")
compare_fitted(list("nec" = ecx4param, "ecx" = nec4param))
}

}
\seealso{
\code{\link{bnec}}
}
