% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion.R
\name{dispersion}
\alias{dispersion}
\title{Posterior dispersion}
\usage{
dispersion(model, summary = FALSE, seed = 10)
}
\arguments{
\item{model}{An object of class \code{\link{bayesnecfit}} whose distribution
family is either \code{\link[stats]{poisson}} or
\code{\link[stats]{binomial}}.}

\item{summary}{Logical. Should summary stats be returned instead of full
vector? Defaults to FALSE.}

\item{seed}{Change seed for reproducible purposes.}
}
\value{
A \code{\link[base]{numeric}} vector. If \code{summary} is FALSE, an
n-long vector containing the dispersion metric, where n is the number of post
warm-up posterior draws from the \code{\link[brms]{brmsfit}} object. If
TRUE, then a \code{\link[base]{data.frame}} containing the summary stats
(mean, median, 95\% highest density intervals) of the dispersion metric.
}
\description{
Calculates posterior dispersion metric
}
\details{
This function calculates a dispersion metric which takes the ratio
between the observed relative to simulated Pearson residuals sums of
squares.
}
\examples{
\donttest{
library(bayesnec)
data(nec_data)
nec_data$y <- as.integer(round(nec_data$y * 100))
nec4param <- bnec(y ~ crf(x, "nec4param"), data = nec_data, chains = 2)
dispersion(nec4param, summary = TRUE)
}
}
\references{
Zuur, A. F., Hilbe, J. M., & Ieno, E. N. (2013). A Beginner's Guide to GLM
and GLMM with R: A Frequentist and Bayesian Perspective for Ecologists.
Highland Statistics Limited.
}
