% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesmanecfit-methods.R
\name{plot.bayesmanecfit}
\alias{plot.bayesmanecfit}
\title{plot.bayesmanecfit}
\usage{
\method{plot}{bayesmanecfit}(
  x,
  ...,
  CI = TRUE,
  add_nec = TRUE,
  position_legend = "topright",
  add_ec10 = FALSE,
  xform = NA,
  lxform = NA,
  force_x = FALSE,
  jitter_x = FALSE,
  jitter_y = FALSE,
  ylab = "Response",
  xlab = "Predictor",
  xticks = NA,
  all_models = FALSE
)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} as returned by
\code{\link{bnec}}.}

\item{...}{Additional arguments to \code{\link[graphics]{plot}}.}

\item{CI}{A \code{\link[base]{logical}} value indicating if credibility
intervals on the model fit should be plotted, calculated as the upper and
lower bounds of the individual predicted values from all posterior samples.}

\item{add_nec}{A \code{\link[base]{logical}} value indicating if the
estimated NEC value and 95\% credible intervals should be added to the plot.}

\item{position_legend}{A \code{\link[base]{numeric}} vector indicating the
location of the NEC or EC10 legend, as per a call to legend.}

\item{add_ec10}{A \code{\link[base]{logical}} value indicating if an
estimated EC10 value and 95\% credible intervals should be added to the plot.}

\item{xform}{A function to be applied as a transformation of the x data.}

\item{lxform}{A function to be applied as a transformation only to axis
labels and the annotated NEC / EC10 values.}

\item{force_x}{A \code{\link[base]{logical}} value indicating if the argument
\code{xform} should be forced on the predictor values. This is useful when
the user transforms the predictor beforehand
(e.g. when using a non-standard base function).}

\item{jitter_x}{A \code{\link[base]{logical}} value indicating if the x
data points on the plot should be jittered.}

\item{jitter_y}{A \code{\link[base]{logical}} value indicating if the y
data points on the plot should be jittered.}

\item{ylab}{A \code{\link[base]{character}} vector to use for the y-axis
label.}

\item{xlab}{A \code{\link[base]{character}} vector to use for the x-axis
label.}

\item{xticks}{A numeric vector indicate where to place the tick marks of
the x-axis.}

\item{all_models}{A \code{\link[base]{logical}} value indicating if all
models in the model set should be plotted simultaneously, or if a model
average plot should be returned.}
}
\value{
a plot of the fitted model
}
\description{
Generates a plot of a fitted \code{\link{bayesmanecfit}} object, as
returned by \code{\link{bnec}}.
}
