% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_out.R
\name{pull_out}
\alias{pull_out}
\title{pull_out}
\usage{
pull_out(manec, model, loo_controls, ...)
}
\arguments{
\item{manec}{An object of class \code{\link{bayesmanecfit}} as returned by
\code{\link{bnec}}.}

\item{model}{A \code{\link[base]{character}} string indicating
which model or suite of models to pull out.}

\item{loo_controls}{A named \code{\link[base]{list}} of two elements
("fitting" and/or "weights"), each being a named \code{\link[base]{list}}
containing the desired arguments to be passed on to \code{\link[brms]{loo}}
(via "fitting") or to \code{\link[loo]{loo_model_weights}} (via "weights").
If "fitting" is provided with argument \code{pointwise = TRUE}
(due to memory issues) and \code{family = "beta_binomial2"}, the
\code{\link{bnec}} will fail because that is a custom family. If "weights" is
not provided by the user, \code{\link{bnec}} will set the default
\code{method} argument in \code{\link[loo]{loo_model_weights}} to
"pseudobma". See ?\code{\link[loo]{loo_model_weights}} for further info.}

\item{...}{Additional arguments to \code{\link{expand_nec}} or
\code{\link{expand_manec}}.}
}
\value{
If \code{model} is a string representing a single model, an object
of class \code{\link{bayesnecfit}}; If \code{model} is instead a string
depicting a suite of models, and object of class \code{\link{bayesmanecfit}}.
}
\description{
Subsets model(s) from an existing object of class \code{\link{bayesmanecfit}}
}
\examples{
\dontrun{
library(bayesnec)
data(manec_example)
nec4param <- pull_out(manec_example, model = "nec4param")
# use "ecx" to get all ECx-containing models
# (only one ["ecx4param"] in this minimal example)
ecx_models <- pull_out(manec_example, model = "ecx")
}

}
\seealso{
\code{\link{bnec}}, \code{\link{models}}.
}
